/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefModuleImpl
extends RefEntityImpl
implements RefModule {
    private final Module myModule;

    protected RefModuleImpl(@NotNull Module module, @NotNull RefManager manager) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInspection/reference/RefModuleImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefModuleImpl", "<init>"));
        }
        super(module.getName(), manager);
        this.myModule = module;
        ((RefProjectImpl)manager.getRefProject()).add(this);
    }

    @Override
    public void add(RefEntity child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        }
        this.myChildren.add(child);
        if (child.getOwner() == null) {
            ((RefEntityImpl)child).setOwner(this);
        }
    }

    @Override
    protected void removeChild(RefEntity child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
        }
    }

    @Override
    public void accept(final @NotNull RefVisitor refVisitor) {
        if (refVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refVisitor", "com/intellij/codeInspection/reference/RefModuleImpl", "accept"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                refVisitor.visitModule(RefModuleImpl.this);
            }
        });
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefModuleImpl", "getModule"));
        }
        return module;
    }

    @Override
    public boolean isValid() {
        return !this.myModule.isDisposed();
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return PlatformIcons.CLOSED_MODULE_GROUP_ICON;
    }

    @Nullable
    public static RefEntity moduleFromName(RefManager manager, String name) {
        return manager.getRefModule(ModuleManager.getInstance(manager.getProject()).findModuleByName(name));
    }
}

