/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlTagCanBeJavadocTagInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new HtmlTagCanBeJavaDocTagFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HtmlTagCanBeJavaDocTagVisitor();
    }

    private static class HtmlTagCanBeJavaDocTagVisitor
    extends BaseInspectionVisitor {
        private HtmlTagCanBeJavaDocTagVisitor() {
        }

        @Override
        public void visitDocToken(PsiDocToken token) {
            super.visitDocToken(token);
            IElementType tokenType = token.getTokenType();
            if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType)) {
                return;
            }
            String text = token.getText();
            int startIndex = 0;
            while ((startIndex = text.indexOf("<code>", startIndex)) >= 0) {
                if (HtmlTagCanBeJavaDocTagVisitor.hasMatchingCloseTag(token, startIndex + 6)) {
                    this.registerErrorAtOffset((PsiElement)token, startIndex, 6, new Object[0]);
                }
                ++startIndex;
            }
            return;
        }

        private static boolean hasMatchingCloseTag(PsiElement element, int offset) {
            String text = element.getText();
            int endOffset1 = text.indexOf("</code>", offset);
            if (endOffset1 >= 0) {
                int startOffset1 = text.indexOf("<code>", offset);
                return startOffset1 < 0 || startOffset1 > endOffset1;
            }
            for (PsiElement sibling = element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                String text1 = sibling.getText();
                int endOffset = text1.indexOf("</code>");
                if (endOffset < 0) continue;
                int startOffset = text1.indexOf("<code>");
                return startOffset < 0 || startOffset > endOffset;
            }
            return false;
        }
    }

    private static class HtmlTagCanBeJavaDocTagFix
    extends InspectionGadgetsFix {
        private HtmlTagCanBeJavaDocTagFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection$HtmlTagCanBeJavaDocTagFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection$HtmlTagCanBeJavaDocTagFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            TextRange range = descriptor.getTextRangeInElement();
            PsiElement element = descriptor.getPsiElement();
            PsiFile file = PsiTreeUtil.getParentOfType(element, PsiFile.class);
            if (file == null) {
                return;
            }
            Document document = PsiDocumentManager.getInstance(project).getDocument(file);
            if (document == null) {
                return;
            }
            int startOffset = range.getStartOffset();
            int replaceStartOffset = element.getTextOffset() + startOffset;
            int startTag = range.getEndOffset();
            String text = element.getText();
            if (!"<code>".equals(text.substring(startOffset, startTag))) {
                return;
            }
            StringBuilder newCommentText = new StringBuilder("{@code");
            int endTag = text.indexOf("</code>", startTag);
            while (endTag < 0) {
                HtmlTagCanBeJavaDocTagFix.appendElementText(text, startTag, text.length(), newCommentText);
                element = element.getNextSibling();
                if (element == null) {
                    return;
                }
                startTag = 0;
                text = element.getText();
                endTag = text.indexOf("</code>");
            }
            HtmlTagCanBeJavaDocTagFix.appendElementText(text, startTag, endTag, newCommentText);
            newCommentText.append('}');
            int replaceEndOffset = element.getTextOffset() + endTag + 7;
            String oldText = document.getText(new TextRange(replaceStartOffset, replaceEndOffset));
            if (!oldText.startsWith("<code>") || !oldText.endsWith("</code>")) {
                return;
            }
            document.replaceString(replaceStartOffset, replaceEndOffset, newCommentText);
        }

        private static void appendElementText(String text, int startOffset, int endOffset, StringBuilder out) {
            if (out.length() == "{@code".length() && endOffset - startOffset > 0 && !Character.isWhitespace(text.charAt(startOffset))) {
                out.append(' ');
            }
            out.append(text, startOffset, endOffset);
        }
    }
}

