/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BooleanMethodNameMustStartWithQuestionInspectionBase
extends BaseInspection {
    public boolean ignoreBooleanMethods = false;
    public boolean ignoreInAnnotationInterface = true;
    public boolean onlyWarnOnBaseMethods = true;
    @NonNls
    public String questionString = "is,can,has,should,could,will,shall,check,contains,equals,add,put,remove,startsWith,endsWith";
    List<String> questionList = new ArrayList<String>(32);

    public BooleanMethodNameMustStartWithQuestionInspectionBase() {
        BooleanMethodNameMustStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        BooleanMethodNameMustStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase", "writeSettings"));
        }
        this.questionString = BooleanMethodNameMustStartWithQuestionInspectionBase.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanMethodNameMustStartWithQuestionVisitor();
    }

    private class BooleanMethodNameMustStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private BooleanMethodNameMustStartWithQuestionVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass containingClass;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspectionBase$BooleanMethodNameMustStartWithQuestionVisitor", "visitMethod"));
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            if (!(returnType.equals(PsiType.BOOLEAN) || !BooleanMethodNameMustStartWithQuestionInspectionBase.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean"))) {
                return;
            }
            if (BooleanMethodNameMustStartWithQuestionInspectionBase.this.ignoreInAnnotationInterface && (containingClass = method.getContainingClass()) != null && containingClass.isAnnotationType()) {
                return;
            }
            String name = method.getName();
            for (String question : BooleanMethodNameMustStartWithQuestionInspectionBase.this.questionList) {
                if (!name.startsWith(question)) continue;
                return;
            }
            if (BooleanMethodNameMustStartWithQuestionInspectionBase.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

