/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentExcludedVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private final Set<String> excludes;
    private final boolean myBuilderPattern;
    private boolean passed;

    public VariablePassedAsArgumentExcludedVisitor(@NotNull PsiVariable variable, @NotNull Set<String> excludes, boolean builderPattern) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor", "<init>"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor", "<init>"));
        }
        this.passed = false;
        this.variable = variable;
        this.excludes = excludes;
        this.myBuilderPattern = builderPattern;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariablePassedAsArgumentExcludedVisitor", "visitElement"));
        }
        if (this.passed) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitCallExpression(PsiCallExpression callExpression) {
        if (this.passed) {
            return;
        }
        super.visitCallExpression(callExpression);
        this.visitCall(callExpression);
    }

    @Override
    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall(enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            String name;
            PsiClass aClass;
            PsiMethod method;
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable, this.myBuilderPattern) || (method = call.resolveMethod()) != null && (aClass = method.getContainingClass()) != null && this.excludes.contains(name = aClass.getQualifiedName())) continue;
            this.passed = true;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

