/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class MismatchedArrayReadWriteInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("MismatchedReadAndWriteOfArray" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "getID"));
        }
        return "MismatchedReadAndWriteOfArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean written = (Boolean)infos[0];
        if (written) {
            String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.write.not.read", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.read.not.write", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedArrayReadWriteVisitor();
    }

    private static class MismatchedArrayReadWriteVisitor
    extends BaseInspectionVisitor {
        private MismatchedArrayReadWriteVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            boolean read;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "visitField"));
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!MismatchedArrayReadWriteVisitor.checkVariable(field, containingClass)) {
                return;
            }
            boolean written = MismatchedArrayReadWriteVisitor.arrayContentsAreWritten(field, containingClass);
            if (written == (read = MismatchedArrayReadWriteVisitor.arrayContentsAreRead(field, containingClass))) {
                return;
            }
            this.registerFieldError(field, written);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            boolean read;
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedArrayReadWriteVisitor.checkVariable(variable, codeBlock)) {
                return;
            }
            boolean written = MismatchedArrayReadWriteVisitor.arrayContentsAreWritten(variable, codeBlock);
            if (written == (read = MismatchedArrayReadWriteVisitor.arrayContentsAreRead(variable, codeBlock))) {
                return;
            }
            this.registerVariableError(variable, written);
        }

        private static boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type = variable.getType();
            if (type.getArrayDimensions() == 0) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean arrayContentsAreWritten(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.arrayContentsAreAssigned(variable, context)) {
                return true;
            }
            if (!MismatchedArrayReadWriteVisitor.isDefaultArrayInitializer(variable.getInitializer())) {
                return true;
            }
            return MismatchedArrayReadWriteVisitor.variableIsWritten(variable, context);
        }

        private static boolean arrayContentsAreRead(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.arrayContentsAreAccessed(variable, context)) {
                return true;
            }
            if (MismatchedArrayReadWriteVisitor.isPossiblyReferenceThatIsReadLater(variable.getInitializer())) {
                return true;
            }
            return MismatchedArrayReadWriteVisitor.variableIsRead(variable, context);
        }

        private static boolean isPossiblyReferenceThatIsReadLater(PsiExpression initializer) {
            if (initializer == null || initializer instanceof PsiNewExpression || initializer instanceof PsiArrayInitializerExpression) {
                return false;
            }
            if (initializer instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)initializer;
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return false;
                }
                String name = method.getName();
                if (!"copyOf".equals(name) && !"copyOfRange".equals(name)) {
                    return true;
                }
                PsiClass aClass = method.getContainingClass();
                return aClass == null || !"java.util.Arrays".equals(aClass.getQualifiedName());
            }
            return true;
        }

        private static boolean isDefaultArrayInitializer(PsiExpression initializer) {
            if (initializer == null) {
                return true;
            }
            if (initializer instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return arrayInitializer == null || MismatchedArrayReadWriteVisitor.isDefaultArrayInitializer(arrayInitializer);
            }
            if (initializer instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                return initializers.length == 0;
            }
            return false;
        }

        public static boolean variableIsWritten(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "variableIsWritten"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "variableIsWritten"));
            }
            VariableReadWriteVisitor visitor = new VariableReadWriteVisitor(variable, true);
            context.accept(visitor);
            return visitor.isPassed();
        }

        public static boolean variableIsRead(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "variableIsRead"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor", "variableIsRead"));
            }
            VariableReadWriteVisitor visitor = new VariableReadWriteVisitor(variable, false);
            context.accept(visitor);
            return visitor.isPassed();
        }

        static class VariableReadWriteVisitor
        extends JavaRecursiveElementVisitor {
            @NotNull
            private final PsiVariable variable;
            private final boolean write;
            private boolean passed;

            VariableReadWriteVisitor(@NotNull PsiVariable variable, boolean write) {
                if (variable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariableReadWriteVisitor", "<init>"));
                }
                this.passed = false;
                this.variable = variable;
                this.write = write;
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariableReadWriteVisitor", "visitElement"));
                }
                if (!this.passed) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitBinaryExpression(PsiBinaryExpression expression) {
                PsiExpression rhs;
                super.visitBinaryExpression(expression);
                if (this.write || this.passed) {
                    return;
                }
                IElementType tokenType = expression.getOperationTokenType();
                if (!JavaTokenType.EQEQ.equals(tokenType) && !JavaTokenType.NE.equals(tokenType)) {
                    return;
                }
                PsiExpression lhs = expression.getLOperand();
                if (!(lhs instanceof PsiBinaryExpression) && VariableAccessUtils.mayEvaluateToVariable(lhs, this.variable)) {
                    this.passed = true;
                }
                if (!((rhs = expression.getROperand()) instanceof PsiBinaryExpression) && VariableAccessUtils.mayEvaluateToVariable(rhs, this.variable)) {
                    this.passed = true;
                }
            }

            @Override
            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariableReadWriteVisitor", "visitMethodCallExpression"));
                }
                if (this.passed) {
                    return;
                }
                super.visitMethodCallExpression(call);
                PsiExpressionList argumentList = call.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
                    if (this.write && i == 0 && VariableReadWriteVisitor.isCallToSystemArraycopy(call)) {
                        return;
                    }
                    if (!this.write && i == 2 && VariableReadWriteVisitor.isCallToSystemArraycopy(call)) {
                        return;
                    }
                    this.passed = true;
                }
            }

            private static boolean isCallToSystemArraycopy(PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (!"arraycopy".equals(name)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                return "java.lang.System".equals(((PsiClass)element).getQualifiedName());
            }

            @Override
            public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                if (newExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$VariableReadWriteVisitor", "visitNewExpression"));
                }
                if (this.passed) {
                    return;
                }
                super.visitNewExpression(newExpression);
                this.visitPsiCall(newExpression);
            }

            @Override
            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                if (this.passed) {
                    return;
                }
                super.visitEnumConstant(enumConstant);
                this.visitPsiCall(enumConstant);
            }

            private void visitPsiCall(PsiCall newExpression) {
                PsiExpression[] arguments;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
                    this.passed = true;
                }
            }

            public boolean isPassed() {
                return this.passed;
            }
        }
    }
}

