/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class ConditionSignalInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("CallToSignalInsteadOfSignalAll" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ConditionSignalInspection", "getID"));
        }
        return "CallToSignalInsteadOfSignalAll";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("condition.signal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ConditionSignalInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("condition.signal.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ConditionSignalInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionSignalVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConditionSignalFix();
    }

    private static class ConditionSignalVisitor
    extends BaseInspectionVisitor {
        private ConditionSignalVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ConditionSignalInspection$ConditionSignalVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String signal = "signal";
            if (!"signal".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor(containingClass, "java.util.concurrent.locks.Condition")) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class ConditionSignalFix
    extends InspectionGadgetsFix {
        private ConditionSignalFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("condition.signal.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ConditionSignalInspection$ConditionSignalFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ConditionSignalInspection$ConditionSignalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            assert (methodExpression != null);
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String signalAll = "signalAll";
            if (qualifier == null) {
                PsiReplacementUtil.replaceExpression(methodExpression, "signalAll");
            } else {
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression(methodExpression, qualifierText + '.' + "signalAll");
            }
        }
    }
}

