/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.StateMerger;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

class StateQueue {
    private final PriorityQueue<DfaInstructionState> myQueue = new PriorityQueue();
    private final Set<Pair<Instruction, DfaMemoryState>> mySet = ContainerUtil.newHashSet();

    StateQueue() {
    }

    void offer(DfaInstructionState state) {
        if (this.mySet.add(Pair.create(state.getInstruction(), state.getMemoryState()))) {
            this.myQueue.offer(state);
        }
    }

    boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    List<DfaInstructionState> getNextInstructionStates(Set<Instruction> joinInstructions) {
        DfaInstructionState state = this.myQueue.poll();
        final Instruction instruction = state.getInstruction();
        this.mySet.remove(Pair.create(instruction, state.getMemoryState()));
        DfaInstructionState next = this.myQueue.peek();
        if (next == null || next.compareTo(state) != 0) {
            return Collections.singletonList(state);
        }
        ArrayList<DfaMemoryStateImpl> memoryStates = ContainerUtil.newArrayList();
        memoryStates.add((DfaMemoryStateImpl)state.getMemoryState());
        while (!this.myQueue.isEmpty() && this.myQueue.peek().compareTo(state) == 0) {
            DfaMemoryState anotherState = this.myQueue.poll().getMemoryState();
            this.mySet.remove(Pair.create(instruction, anotherState));
            memoryStates.add((DfaMemoryStateImpl)anotherState);
        }
        if (memoryStates.size() > 1 && joinInstructions.contains(instruction)) {
            MultiMap<Object, DfaMemoryStateImpl> groups = MultiMap.create();
            for (DfaMemoryStateImpl dfaMemoryStateImpl : memoryStates) {
                groups.putValue(dfaMemoryStateImpl.getSuperficialKey(), dfaMemoryStateImpl);
            }
            memoryStates = ContainerUtil.newArrayList();
            for (Map.Entry entry : groups.entrySet()) {
                memoryStates.addAll(StateQueue.mergeGroup((List)entry.getValue()));
            }
        }
        return ContainerUtil.map(memoryStates, new Function<DfaMemoryStateImpl, DfaInstructionState>(){

            @Override
            public DfaInstructionState fun(DfaMemoryStateImpl state) {
                return new DfaInstructionState(instruction, state);
            }
        });
    }

    private static List<DfaMemoryStateImpl> mergeGroup(List<DfaMemoryStateImpl> group) {
        if (group.size() < 2) {
            return group;
        }
        StateMerger merger = new StateMerger();
        while (true) {
            List<DfaMemoryStateImpl> nextStates;
            if ((nextStates = merger.mergeByFacts(group)) == null) {
                nextStates = merger.mergeByNullability(group);
            }
            if (nextStates == null) {
                nextStates = merger.mergeByUnknowns(group);
            }
            if (nextStates == null) break;
            group = nextStates;
        }
        return group;
    }
}

