/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlParsing {
    @NonNls
    private static final String TR_TAG = "tr";
    @NonNls
    private static final String TD_TAG = "td";
    @NonNls
    private static final String DD_TAG = "dd";
    @NonNls
    private static final String DT_TAG = "dt";
    @NonNls
    private static final String TABLE_TAG = "table";
    private final PsiBuilder myBuilder;
    private final Stack<String> myTagNamesStack = new Stack();
    private final Stack<PsiBuilder.Marker> myTagMarkersStack = new Stack();
    @NonNls
    private static final String COMPLETION_NAME = "IntellijIdeaRulezzz".toLowerCase();
    private static final int MAGIC_FRAME_COUNT = 450;

    public HtmlParsing(PsiBuilder builder) {
        this.myBuilder = builder;
    }

    public void parseDocument() {
        PsiBuilder.Marker document = this.mark();
        while (this.token() == XmlTokenType.XML_COMMENT_START) {
            this.parseComment();
        }
        this.parseProlog();
        PsiBuilder.Marker error = null;
        while (!this.eof()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                error = HtmlParsing.flushError(error);
                this.parseTag("");
                this.myTagMarkersStack.clear();
                this.myTagNamesStack.clear();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                error = HtmlParsing.flushError(error);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                error = HtmlParsing.flushError(error);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF || tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_REAL_WHITE_SPACE || tt == XmlTokenType.XML_DATA_CHARACTERS) {
                error = HtmlParsing.flushError(error);
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_END_TAG_START) {
                PsiBuilder.Marker tagEndError = this.myBuilder.mark();
                this.advance();
                if (this.token() == XmlTokenType.XML_NAME) {
                    this.advance();
                    if (this.token() == XmlTokenType.XML_TAG_END) {
                        this.advance();
                    }
                }
                tagEndError.error(XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]));
                continue;
            }
            if (error == null) {
                error = this.mark();
            }
            this.advance();
        }
        if (error != null) {
            error.error(XmlErrorMessages.message("top.level.element.is.not.completed", new Object[0]));
        }
        document.done(XmlElementType.HTML_DOCUMENT);
    }

    @Nullable
    private static PsiBuilder.Marker flushError(PsiBuilder.Marker error) {
        if (error != null) {
            error.error(XmlErrorMessages.message("xml.parsing.unexpected.tokens", new Object[0]));
            error = null;
        }
        return error;
    }

    private void parseDoctype() {
        assert (this.token() == XmlTokenType.XML_DOCTYPE_START) : "Doctype start expected";
        PsiBuilder.Marker doctype = this.mark();
        this.advance();
        while (this.token() != XmlTokenType.XML_DOCTYPE_END && !this.eof()) {
            this.advance();
        }
        if (this.eof()) {
            this.error(XmlErrorMessages.message("xml.parsing.unexpected.end.of.file", new Object[0]));
        } else {
            this.advance();
        }
        doctype.done(XmlElementType.XML_DOCTYPE);
    }

    private static boolean ddordt(String name) {
        return DT_TAG.equals(name) || DD_TAG.equals(name);
    }

    private boolean parseTag(String parentName) {
        String originalTagName;
        assert (this.token() == XmlTokenType.XML_START_TAG_START) : "Tag start expected";
        PsiBuilder.Marker tag = this.mark();
        this.myTagMarkersStack.push(tag);
        this.advance();
        if (this.token() != XmlTokenType.XML_NAME) {
            this.error(XmlErrorMessages.message("xml.parsing.tag.name.expected", new Object[0]));
            originalTagName = "";
        } else {
            originalTagName = this.myBuilder.getTokenText();
            this.advance();
        }
        String tagName = StringUtil.toLowerCase(originalTagName);
        if (HtmlParsing.ddordt(tagName) && HtmlParsing.ddordt(parentName) || tagName.equals(parentName) && HtmlUtil.isOptionalEndForHtmlTagL(tagName) || this.myTagMarkersStack.size() > 450) {
            tag.rollbackTo();
            this.myTagMarkersStack.pop();
            return false;
        }
        this.myTagNamesStack.push(tagName);
        boolean freeMakerTag = !tagName.isEmpty() && '#' == tagName.charAt(0);
        do {
            IElementType tt = this.token();
            if (freeMakerTag) {
                if (tt == XmlTokenType.XML_EMPTY_ELEMENT_END || tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_END_TAG_START || tt == XmlTokenType.XML_START_TAG_START) break;
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_NAME) {
                this.parseAttribute();
                continue;
            }
            if (tt != XmlTokenType.XML_CHAR_ENTITY_REF && tt != XmlTokenType.XML_ENTITY_REF_TOKEN) break;
            this.parseReference();
        } while (!this.eof());
        if (this.token() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            this.advance();
            tag.done(XmlElementType.HTML_TAG);
            return true;
        }
        if (this.token() != XmlTokenType.XML_TAG_END) {
            this.error(XmlErrorMessages.message("tag.start.is.not.closed", new Object[0]));
            tag.done(XmlElementType.HTML_TAG);
            return true;
        }
        this.advance();
        if (HtmlUtil.isSingleHtmlTagL(tagName)) {
            PsiBuilder.Marker footer = this.mark();
            if (this.token() == XmlTokenType.XML_END_TAG_START) {
                this.advance();
                if (this.token() == XmlTokenType.XML_NAME && tagName.equalsIgnoreCase(this.myBuilder.getTokenText())) {
                    this.advance();
                    footer.drop();
                    if (this.token() == XmlTokenType.XML_TAG_END) {
                        this.advance();
                    }
                    tag.done(XmlElementType.HTML_TAG);
                    return true;
                }
            }
            footer.rollbackTo();
            tag.done(XmlElementType.HTML_TAG);
            return true;
        }
        boolean isInlineTagContainer = HtmlUtil.isInlineTagContainerL(tagName);
        boolean isOptionalTagEnd = HtmlUtil.isOptionalEndForHtmlTagL(tagName);
        PsiBuilder.Marker firstBlockChild = null;
        PsiBuilder.Marker xmlText = null;
        while (!this.eof()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                boolean foundMatch;
                xmlText = HtmlParsing.terminateText(xmlText);
                if (!this.parseTag(tagName)) {
                    tag.done(XmlElementType.HTML_TAG);
                    return true;
                }
                PsiBuilder.Marker childMarker = this.myTagMarkersStack.pop();
                String childName = this.myTagNamesStack.pop();
                if (isOptionalTagEnd && (foundMatch = this.childTerminatesParentInStack(childName, true))) {
                    if (!HtmlParsing.canTerminate(childName, tagName)) {
                        this.myTagMarkersStack.pop();
                        this.myTagNamesStack.pop();
                        this.myTagMarkersStack.push(childMarker);
                        this.myTagNamesStack.push(childName);
                    }
                    tag.doneBefore(XmlElementType.HTML_TAG, childMarker);
                    return true;
                }
                if (isInlineTagContainer && HtmlUtil.isHtmlBlockTagL(childName) && isOptionalTagEnd && !HtmlUtil.isPossiblyInlineTag(childName)) {
                    tag.doneBefore(XmlElementType.HTML_TAG, childMarker);
                    return true;
                }
                if (!isOptionalTagEnd || firstBlockChild != null || !HtmlUtil.isHtmlBlockTagL(childName) || HtmlUtil.isHtmlBlockTagL(tagName) || !HtmlParsing.canTerminate(childName, tagName)) continue;
                firstBlockChild = childMarker;
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                xmlText = this.startText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_CDATA_START) {
                xmlText = this.startText(xmlText);
                this.parseCData();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                xmlText = this.startText(xmlText);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                xmlText = this.startText(xmlText);
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(XmlErrorMessages.message("unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                continue;
            }
            if (tt instanceof CustomParsingType || tt instanceof ILazyParseableElementType) {
                xmlText = HtmlParsing.terminateText(xmlText);
                this.advance();
                continue;
            }
            if (this.token() == XmlTokenType.XML_END_TAG_START) {
                xmlText = HtmlParsing.terminateText(xmlText);
                PsiBuilder.Marker footer = this.mark();
                this.advance();
                if (this.token() == XmlTokenType.XML_NAME) {
                    String endName = StringUtil.toLowerCase(this.myBuilder.getTokenText());
                    if (!tagName.equals(endName) && !endName.endsWith(COMPLETION_NAME)) {
                        boolean hasChancesToMatch;
                        boolean bl = hasChancesToMatch = HtmlUtil.isOptionalEndForHtmlTagL(endName) ? this.childTerminatesParentInStack(endName, false) : this.myTagNamesStack.contains(endName);
                        if (hasChancesToMatch) {
                            footer.rollbackTo();
                            if (isOptionalTagEnd) {
                                if (firstBlockChild != null) {
                                    tag.doneBefore(XmlElementType.HTML_TAG, firstBlockChild);
                                } else {
                                    tag.done(XmlElementType.HTML_TAG);
                                }
                            } else {
                                this.error(XmlErrorMessages.message("named.element.is.not.closed", originalTagName));
                                tag.done(XmlElementType.HTML_TAG);
                            }
                            return true;
                        }
                        this.advance();
                        if (this.token() == XmlTokenType.XML_TAG_END) {
                            this.advance();
                        }
                        footer.error(XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]));
                        continue;
                    }
                    this.advance();
                    while (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_START_TAG_START && this.token() != XmlTokenType.XML_END_TAG_START && !this.eof()) {
                        this.error(XmlErrorMessages.message("xml.parsing.unexpected.token", new Object[0]));
                        this.advance();
                    }
                } else {
                    this.error(XmlErrorMessages.message("xml.parsing.closing.tag.name.missing", new Object[0]));
                }
                footer.drop();
                if (this.token() == XmlTokenType.XML_TAG_END) {
                    this.advance();
                } else {
                    this.error(XmlErrorMessages.message("xml.parsing.closing.tag.is.not.done", new Object[0]));
                }
                tag.done(XmlElementType.HTML_TAG);
                return true;
            }
            xmlText = this.startText(xmlText);
            this.advance();
        }
        HtmlParsing.terminateText(xmlText);
        if (isOptionalTagEnd || "body".equalsIgnoreCase(tagName) || "html".equalsIgnoreCase(tagName)) {
            if (firstBlockChild != null) {
                tag.doneBefore(XmlElementType.HTML_TAG, firstBlockChild);
            } else {
                tag.done(XmlElementType.HTML_TAG);
            }
        } else {
            this.error(XmlErrorMessages.message("named.element.is.not.closed", originalTagName));
            tag.done(XmlElementType.HTML_TAG);
        }
        return true;
    }

    private static boolean canTerminate(String childTagName, String tagName) {
        return childTagName.equals(tagName) || HtmlUtil.canTerminate(childTagName, tagName);
    }

    private boolean childTerminatesParentInStack(String childName, boolean terminateOnNonOptionalTag) {
        boolean isCell = TD_TAG.equals(childName) || "th".equals(childName);
        boolean isRow = TR_TAG.equals(childName);
        for (int i = this.myTagNamesStack.size() - 1; i >= 0; --i) {
            String parentName = (String)this.myTagNamesStack.get(i);
            if (terminateOnNonOptionalTag && !HtmlUtil.isOptionalEndForHtmlTagL(parentName)) {
                return false;
            }
            if (isCell && (TR_TAG.equals(parentName) || TABLE_TAG.equals(parentName)) || isRow && TABLE_TAG.equals(parentName)) {
                return false;
            }
            if (!HtmlParsing.canTerminate(childName, parentName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private PsiBuilder.Marker startText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText == null) {
            xmlText = this.mark();
            assert (xmlText != null);
        }
        PsiBuilder.Marker marker = xmlText;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlParsing", "startText"));
        }
        return marker;
    }

    protected final PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    @Nullable
    private static PsiBuilder.Marker terminateText(@Nullable PsiBuilder.Marker xmlText) {
        if (xmlText != null) {
            xmlText.done(XmlElementType.XML_TEXT);
            xmlText = null;
        }
        return xmlText;
    }

    private void parseCData() {
        assert (this.token() == XmlTokenType.XML_CDATA_START);
        PsiBuilder.Marker cdata = this.mark();
        while (this.token() != XmlTokenType.XML_CDATA_END && !this.eof()) {
            this.advance();
        }
        if (!this.eof()) {
            this.advance();
        }
        cdata.done(XmlElementType.XML_CDATA);
    }

    protected void parseComment() {
        IElementType tt;
        PsiBuilder.Marker comment = this.mark();
        this.advance();
        while (true) {
            if ((tt = this.token()) == XmlTokenType.XML_COMMENT_CHARACTERS || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_START || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_START_END || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_END_START || tt == XmlTokenType.XML_CONDITIONAL_COMMENT_END) {
                this.advance();
                continue;
            }
            if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN || tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                this.parseReference();
                continue;
            }
            if (tt != XmlTokenType.XML_BAD_CHARACTER) break;
            PsiBuilder.Marker error = this.mark();
            this.advance();
            error.error(XmlErrorMessages.message("xml.parsing.bad.character", new Object[0]));
        }
        if (tt == XmlTokenType.XML_COMMENT_END) {
            this.advance();
        }
        comment.done(XmlElementType.XML_COMMENT);
    }

    private void parseReference() {
        if (this.token() == XmlTokenType.XML_CHAR_ENTITY_REF) {
            this.advance();
        } else if (this.token() == XmlTokenType.XML_ENTITY_REF_TOKEN) {
            PsiBuilder.Marker ref = this.mark();
            this.advance();
            ref.done(XmlElementType.XML_ENTITY_REF);
        } else assert (false) : "Unexpected token";
    }

    private void parseAttribute() {
        assert (this.token() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.mark();
        this.advance();
        if (this.token() == XmlTokenType.XML_EQ) {
            this.advance();
            this.parseAttributeValue();
            att.done(XmlElementType.XML_ATTRIBUTE);
        } else {
            att.done(XmlElementType.XML_ATTRIBUTE);
        }
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.mark();
        if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.token()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlErrorMessages.message("unescaped.ampersand.or.nonterminated.character.entity.reference", new Object[0]));
                    continue;
                }
                if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                this.advance();
            }
            if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlErrorMessages.message("xml.parsing.unclosed.attribute.value", new Object[0]));
            }
        } else if (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            this.advance();
        }
        attValue.done(XmlElementType.XML_ATTRIBUTE_VALUE);
    }

    private void parseProlog() {
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlTokenType.XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (tt != XmlTokenType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        PsiBuilder.Marker prolog = this.mark();
        while (true) {
            IElementType tt;
            if ((tt = this.token()) == XmlTokenType.XML_PI_START) {
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_DOCTYPE_START) {
                this.parseDoctype();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (tt != XmlTokenType.XML_REAL_WHITE_SPACE) break;
            this.advance();
        }
        prolog.done(XmlElementType.XML_PROLOG);
    }

    private void parseProcessingInstruction() {
        assert (this.token() == XmlTokenType.XML_PI_START);
        PsiBuilder.Marker pi = this.mark();
        this.advance();
        if (this.token() == XmlTokenType.XML_NAME || this.token() == XmlTokenType.XML_PI_TARGET) {
            this.advance();
        }
        while (this.token() == XmlTokenType.XML_NAME) {
            this.advance();
            if (this.token() == XmlTokenType.XML_EQ) {
                this.advance();
            } else {
                this.error(XmlErrorMessages.message("expected.attribute.eq.sign", new Object[0]));
            }
            this.parseAttributeValue();
        }
        if (this.token() == XmlTokenType.XML_PI_END) {
            this.advance();
        } else {
            this.error(XmlErrorMessages.message("xml.parsing.unterminated.processing.instruction", new Object[0]));
        }
        pi.done(XmlElementType.XML_PROCESSING_INSTRUCTION);
    }

    protected final IElementType token() {
        return this.myBuilder.getTokenType();
    }

    protected final boolean eof() {
        return this.myBuilder.eof();
    }

    protected final void advance() {
        this.myBuilder.advanceLexer();
    }

    private void error(String message) {
        this.myBuilder.error(message);
    }
}

