/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleLibraryOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements LibraryOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.LibraryOrderEntryImpl");
    private final Library myLibrary;
    @NonNls
    public static final String ENTRY_TYPE = "module-library";
    private boolean myExported;
    @NonNls
    public static final String EXPORTED_ATTR = "exported";

    private ModuleLibraryOrderEntryImpl(Library library, RootModelImpl rootModel, boolean isExported, DependencyScope scope) {
        super(rootModel, ProjectRootManagerImpl.getInstanceImpl(rootModel.getProject()));
        this.myLibrary = ((LibraryImpl)library).cloneLibrary(this.getRootModel());
        this.doinit();
        this.myExported = isExported;
        this.myScope = scope;
    }

    ModuleLibraryOrderEntryImpl(String name, PersistentLibraryKind kind, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.myLibrary = LibraryTableImplUtil.createModuleLevelLibrary(name, kind, this.getRootModel());
        this.doinit();
    }

    ModuleLibraryOrderEntryImpl(Element element, RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        super(rootModel, projectRootManager);
        LOG.assertTrue(ENTRY_TYPE.equals(element.getAttributeValue("type")));
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        this.myScope = DependencyScope.readExternal(element);
        this.myLibrary = LibraryTableImplUtil.loadLibrary(element, this.getRootModel());
        this.doinit();
    }

    private void doinit() {
        Disposer.register(this, this.myLibrary);
        this.init();
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myLibrary.getRootProvider();
    }

    @Override
    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public boolean isModuleLevel() {
        return true;
    }

    @Override
    public String getLibraryName() {
        return this.myLibrary.getName();
    }

    @Override
    public String getLibraryLevel() {
        return "module";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String name = this.myLibrary.getName();
        if (name != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl", "getPresentableName"));
            }
            return string;
        }
        if (this.myLibrary instanceof LibraryEx && ((LibraryEx)this.myLibrary).isDisposed()) {
            if ("<unknown>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl", "getPresentableName"));
            }
            return "<unknown>";
        }
        String[] urls = this.myLibrary.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            String url = urls[0];
            String string = PathUtil.toPresentableUrl(url);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl", "getPresentableName"));
            }
            return string;
        }
        String string = ProjectBundle.message("library.empty.library.item", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && this.myLibrary != null;
    }

    @Override
    public <R> R accept(RootPolicy<R> policy, R initialValue) {
        return policy.visitLibraryOrderEntry(this, initialValue);
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public OrderEntry cloneEntry(RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        return new ModuleLibraryOrderEntryImpl(this.myLibrary, rootModel, this.myExported, this.myScope);
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        this.myLibrary.writeExternal(element);
        rootElement.addContent(element);
    }

    @Override
    public boolean isExported() {
        return this.myExported;
    }

    @Override
    public void setExported(boolean value) {
        this.myExported = value;
    }

    @Override
    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl", "getScope"));
        }
        return dependencyScope;
    }

    @Override
    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl", "setScope"));
        }
        this.myScope = scope;
    }
}

