/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AssignmentToStaticFieldFromInstanceMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.static.field.from.instance.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToStaticFieldFromInstanceMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.static.field.from.instance.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToStaticFieldFromInstanceMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToStaticFieldFromInstanceMethod();
    }

    private static class AssignmentToStaticFieldFromInstanceMethod
    extends BaseInspectionVisitor {
        private AssignmentToStaticFieldFromInstanceMethod() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentToStaticFieldFromInstanceMethodInspection$AssignmentToStaticFieldFromInstanceMethod", "visitAssignmentExpression"));
            }
            PsiExpression lhs = expression.getLExpression();
            this.checkForStaticFieldAccess(lhs);
        }

        @Override
        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentToStaticFieldFromInstanceMethodInspection$AssignmentToStaticFieldFromInstanceMethod", "visitPrefixExpression"));
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            this.checkForStaticFieldAccess(operand);
        }

        @Override
        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentToStaticFieldFromInstanceMethodInspection$AssignmentToStaticFieldFromInstanceMethod", "visitPostfixExpression"));
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            this.checkForStaticFieldAccess(operand);
        }

        private void checkForStaticFieldAccess(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            if (AssignmentToStaticFieldFromInstanceMethod.isInStaticMethod(expression)) {
                return;
            }
            PsiElement referent = ((PsiReference)((Object)expression)).resolve();
            if (referent == null) {
                return;
            }
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField fieldReferenced = (PsiField)referent;
            if (fieldReferenced.hasModifierProperty("static")) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private static boolean isInStaticMethod(PsiElement element) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiClassInitializer.class);
            if (member == null) {
                return false;
            }
            return member.hasModifierProperty("static");
        }
    }
}

