/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.bugs.Validator;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspectionBase
extends BaseInspection {
    @NonNls
    public String additionalClasses = "";
    @NonNls
    public String additionalMethods = "";
    final List<String> classNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();

    public MalformedFormatStringInspectionBase() {
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "writeSettings"));
        }
        this.additionalClasses = MalformedFormatStringInspectionBase.formatString(this.classNames);
        this.additionalMethods = MalformedFormatStringInspectionBase.formatString(this.methodNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.format.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object value = infos[0];
        if (value instanceof Exception) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        Validator[] validators = (Validator[])value;
        int argumentCount = (Integer)infos[1];
        if (validators.length < argumentCount) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (validators.length > argumentCount) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        private MalformedFormatStringVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            Validator[] validators;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase$MalformedFormatStringVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!FormatUtils.isFormatCall(expression, MalformedFormatStringInspectionBase.this.methodNames, MalformedFormatStringInspectionBase.this.classNames)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType type = firstArgument.getType();
            if (type == null) {
                return;
            }
            int formatArgumentIndex = "java.util.Locale".equals(type.getCanonicalText()) && arguments.length > 1 ? 1 : 0;
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            if (!ExpressionUtils.hasStringType(formatArgument)) {
                return;
            }
            if (!PsiUtil.isConstantExpression(formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            if (formatType == null) {
                return;
            }
            String value = (String)ConstantExpressionUtil.computeCastTo(formatArgument, formatType);
            if (value == null) {
                return;
            }
            int argumentCount = arguments.length - (formatArgumentIndex + 1);
            try {
                validators = FormatDecode.decode(value, argumentCount);
            }
            catch (Exception e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (validators.length != argumentCount) {
                PsiExpression argument;
                PsiType argumentType;
                if (argumentCount == 1 && (argumentType = (argument = arguments[formatArgumentIndex + 1]).getType()) instanceof PsiArrayType) {
                    return;
                }
                this.registerError((PsiElement)formatArgument, validators, argumentCount);
                return;
            }
            for (int i = 0; i < validators.length; ++i) {
                Validator validator = validators[i];
                PsiType argumentType = arguments[i + formatArgumentIndex + 1].getType();
                if (argumentType == null || validator == null || validator.valid(argumentType)) continue;
                this.registerError((PsiElement)formatArgument, validators, argumentCount);
                return;
            }
        }
    }
}

