/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ClsFileImpl
extends ClsRepositoryPsiElement<PsiClassHolderFileStub>
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsFileImpl");
    private static final String BANNER = "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n";
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create("cls.document.link");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final FileViewProvider myViewProvider;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile TreeElement myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private volatile LanguageLevel myLanguageLevel;
    private boolean myIsPhysical;
    private static final InnerClassSourceStrategy<VirtualFile> STRATEGY = new InnerClassSourceStrategy<VirtualFile>(){

        @Override
        @Nullable
        public VirtualFile findInnerClass(String innerName, VirtualFile outerClass) {
            String baseName = outerClass.getNameWithoutExtension();
            VirtualFile dir = outerClass.getParent();
            assert (dir != null) : outerClass;
            return dir.findChild(baseName + "$" + innerName + ".class");
        }

        @Override
        public void accept(VirtualFile innerClass, StubBuildingVisitor<VirtualFile> visitor) {
            try {
                byte[] bytes = innerClass.contentsToByteArray();
                new ClassReader(bytes).accept(visitor, 4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        this(viewProvider, false);
    }

    public ClsFileImpl(@NotNull PsiManager manager, @NotNull FileViewProvider viewProvider) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/compiled/ClsFileImpl", "<init>"));
        }
        super(null);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myPackageStatement = null;
        this.myLanguageLevel = null;
        this.myIsPhysical = true;
        this.myViewProvider = viewProvider;
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    @Override
    public PsiManager getManager() {
        return this.myViewProvider.getManager();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myIsForDecompiling || this.getVirtualFile().isValid();
    }

    protected boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getClasses();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        this.getStub();
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            statement = new ClsPackageStatementImpl(this);
        }
        return statement.getPackageName() != null ? statement : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string = statement == null ? "" : statement.getPackageName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getPackageName"));
        }
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getOnDemandImports"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getSingleClassImports"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getImplicitlyImportedPackages"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getImplicitlyImportedPackageReferences"));
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level = this.myLanguageLevel;
        if (level == null) {
            List classes = ApplicationManager.getApplication().runReadAction(new Computable<List>(){

                @Override
                public List compute() {
                    return ClsFileImpl.this.getStub().getChildrenStubs();
                }
            });
            level = !classes.isEmpty() ? ((PsiClassStub)classes.get(0)).getLanguageLevel() : LanguageLevel.HIGHEST;
            this.myLanguageLevel = level;
        }
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsFileImpl", "setName"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsFileImpl", "appendMirrorText"));
        }
        buffer.append(BANNER);
        ClsFileImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
        PsiClass[] classes = this.getClasses();
        if (classes.length > 0) {
            ClsFileImpl.appendText(classes[0], 0, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsFileImpl", "setMirror"));
        }
        Object mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        ClsFileImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
        ClsFileImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiFile navigationElement;
            if (!(customNavigationPolicy instanceof ClsCustomNavigationPolicyEx) || (navigationElement = ((ClsCustomNavigationPolicyEx)customNavigationPolicy).getFileNavigationElement(this)) == null) continue;
            PsiFile psiFile = navigationElement;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getNavigationElement"));
            }
            return psiFile;
        }
        PsiElement psiElement = CachedValuesManager.getCachedValue(this, new CachedValueProvider<PsiElement>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiElement> compute() {
                PsiElement target = JavaPsiImplementationHelper.getInstance(ClsFileImpl.this.getProject()).getClsFileNavigationElement(ClsFileImpl.this);
                ModificationTracker tracker = FileIndexFacade.getInstance(ClsFileImpl.this.getProject()).getRootModificationTracker();
                return CachedValueProvider.Result.create(target, ClsFileImpl.this, target.getContainingFile(), tracker);
            }
        });
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = this.myMirrorFileElement;
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = this.myMirrorFileElement;
                if (mirrorTreeElement == null) {
                    VirtualFile file = this.getVirtualFile();
                    PsiClass[] classes = this.getClasses();
                    String fileName = (classes.length > 0 ? classes[0].getName() : file.getNameWithoutExtension()) + ".java";
                    final Document document = FileDocumentManager.getInstance().getDocument(file);
                    assert (document != null) : file.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith(mirrorText, BANNER);
                    PsiFileFactory factory = PsiFileFactory.getInstance(this.getManager().getProject());
                    PsiFile mirror = factory.createFileFromText(fileName, JavaLanguage.INSTANCE, mirrorText, false, false);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                    try {
                        final TreeElement finalMirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                            @Override
                            public void run() {
                                ClsFileImpl.this.setMirror(finalMirrorTreeElement);
                                ClsFileImpl.this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                            }
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file.getUrl(), internalDecompiler ? e : ClsFileImpl.wrapException(e, file));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                    this.myMirrorFileElement = mirrorTreeElement;
                }
            }
        }
        return mirrorTreeElement.getPsi();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file) {
        PluginId pluginId;
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file);
        if (decompiler instanceof ClassFileDecompilers.Light && (pluginId = PluginManagerCore.getPluginByClassName(decompiler.getClass().getName())) != null) {
            return new PluginException(e, pluginId);
        }
        return e;
    }

    @Override
    public PsiFile getDecompiledPsiFile() {
        return (PsiFile)this.getMirror();
    }

    @Override
    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsFileImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        ClsFileImpl clsFileImpl = this;
        if (clsFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getOriginalFile"));
        }
        return clsFileImpl;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        if (javaClassFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getFileType"));
        }
        return javaClassFileType;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStub"));
        }
        return psiClassHolderFileStub;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/compiled/ClsFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/compiled/ClsFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/compiled/ClsFileImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor.execute(aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
            }
            return stubTree2;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl("corrupted.classfiles", true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (stubTree3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi(this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "getStubTree"));
        }
        return stubTree4;
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        return null;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        ClsPackageStatementImpl packageStatement = new ClsPackageStatementImpl(this);
        Object object2 = this.myMirrorLock;
        synchronized (object2) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = packageStatement;
        }
        this.myLanguageLevel = null;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/compiled/ClsFileImpl", "putInfo"));
        }
        PsiFileImpl.putInfo(this, info);
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return this.myIsPhysical;
    }

    public void setPhysical(boolean isPhysical) {
        this.myIsPhysical = isPhysical;
    }

    public static String decompile(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/compiled/ClsFileImpl", "decompile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/compiled/ClsFileImpl", "decompile"));
        }
        return ((Object)ClsFileImpl.decompile(file)).toString();
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/compiled/ClsFileImpl", "decompile"));
        }
        PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
        final ClsFileImpl clsFile = new ClsFileImpl(new ClassFileViewProvider(manager, file), true);
        final StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                clsFile.appendMirrorText(0, buffer);
            }
        });
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFileImpl", "decompile"));
        }
        return stringBuilder;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file, @NotNull byte[] bytes) throws ClsFormatException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/compiled/ClsFileImpl", "buildFileStub"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/psi/impl/compiled/ClsFileImpl", "buildFileStub"));
        }
        if (ClassFileViewProvider.isInnerClass(file)) {
            return null;
        }
        try {
            PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl("do.not.know.yet", true);
            String className = file.getNameWithoutExtension();
            StubBuildingVisitor<VirtualFile> visitor = new StubBuildingVisitor<VirtualFile>(file, STRATEGY, stub, 0, className);
            try {
                new ClassReader(bytes).accept(visitor, 4);
            }
            catch (OutOfOrderInnerClassException e) {
                return null;
            }
            PsiClassStub<?> result = visitor.getResult();
            if (result == null) {
                return null;
            }
            stub.setPackageName(ClsFileImpl.getPackageName(result));
            return stub;
        }
        catch (Exception e) {
            throw new ClsFormatException(file.getPath() + ": " + e.getMessage(), e);
        }
    }

    private static String getPackageName(@NotNull PsiClassStub<?> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/compiled/ClsFileImpl", "getPackageName"));
        }
        String fqn = result.getQualifiedName();
        String shortName = result.getName();
        return fqn == null || Comparing.equal(shortName, fqn) ? "" : fqn.substring(0, fqn.lastIndexOf(46));
    }
}

