/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertLineSeparatorsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeStyle.AbstractConvertLineSeparatorsAction");
    @NotNull
    private final String mySeparator;

    protected AbstractConvertLineSeparatorsAction(@Nullable String text, @NotNull LineSeparator separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "<init>"));
        }
        this((Object)((Object)separator) + " - " + text, separator.getSeparatorString());
    }

    protected AbstractConvertLineSeparatorsAction(@Nullable String text, @NotNull String separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "<init>"));
        }
        super(text);
        this.mySeparator = separator;
    }

    @Override
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            VirtualFile[] virtualFiles = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            Presentation presentation = e.getPresentation();
            if (virtualFiles != null) {
                if (virtualFiles.length == 1) {
                    presentation.setEnabled(!this.mySeparator.equals(LoadTextUtil.detectLineSeparator(virtualFiles[0], false)));
                } else {
                    presentation.setEnabled(true);
                }
            } else {
                presentation.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        final Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        VirtualFile[] virtualFiles = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles == null) {
            return;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        final VirtualFile projectVirtualDirectory = projectBaseDir != null && projectBaseDir.isDirectory() ? projectBaseDir.findChild(".idea") : null;
        final FileTypeRegistry fileTypeManager = FileTypeRegistry.getInstance();
        for (VirtualFile file : virtualFiles) {
            VfsUtilCore.processFilesRecursively(file, new Processor<VirtualFile>(){

                @Override
                public boolean process(VirtualFile file) {
                    if (AbstractConvertLineSeparatorsAction.shouldProcess(file, project)) {
                        AbstractConvertLineSeparatorsAction.changeLineSeparators(project, file, AbstractConvertLineSeparatorsAction.this.mySeparator);
                    }
                    return true;
                }
            }, new Convertor<VirtualFile, Boolean>(){

                @Override
                public Boolean convert(VirtualFile dir) {
                    return !dir.equals(projectVirtualDirectory) && !fileTypeManager.isFileIgnored(dir);
                }
            });
        }
    }

    public static boolean shouldProcess(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "shouldProcess"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "shouldProcess"));
        }
        if (file.isDirectory() || !file.isWritable() || FileTypeRegistry.getInstance().isFileIgnored(file) || file.getFileType().isBinary() || file.equals(project.getProjectFile()) || file.equals(project.getWorkspaceFile())) {
            return false;
        }
        Module module = FileIndexFacade.getInstance(project).getModuleForFile(file);
        return module == null || !file.equals(module.getModuleFile());
    }

    public static void changeLineSeparators(final @NotNull Project project, final @NotNull VirtualFile virtualFile, final @NotNull String newSeparator) {
        String currentSeparator;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "changeLineSeparators"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "changeLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction", "changeLineSeparators"));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getCachedDocument(virtualFile);
        if (document != null) {
            fileDocumentManager.saveDocument(document);
        }
        String commandText = StringUtil.isEmpty(currentSeparator = LoadTextUtil.detectLineSeparator(virtualFile, false)) ? "Changed line separators to " + (Object)((Object)LineSeparator.fromString(newSeparator)) : String.format("Changed line separators from %s to %s", new Object[]{LineSeparator.fromString(currentSeparator), LineSeparator.fromString(newSeparator)});
        new WriteCommandAction(project, commandText, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeStyle/AbstractConvertLineSeparatorsAction$3", "run"));
                }
                LoadTextUtil.changeLineSeparators(project, virtualFile, newSeparator, this);
            }
        }.execute();
    }
}

