/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Annotation
implements Segment {
    private final int myStartOffset;
    private final int myEndOffset;
    private final HighlightSeverity mySeverity;
    private final String myMessage;
    private ProblemHighlightType myHighlightType;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes;
    private Boolean myNeedsUpdateOnTyping;
    private String myTooltip;
    private boolean myAfterEndOfLine;
    private boolean myIsFileLevelAnnotation;
    private GutterIconRenderer myGutterIconRenderer;
    @Nullable
    private ProblemGroup myProblemGroup;
    private List<QuickFixInfo> myBatchFixes;

    public Annotation(int startOffset, int endOffset, @NotNull HighlightSeverity severity, String message, String tooltip) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/annotation/Annotation", "<init>"));
        }
        this.myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        this.myQuickFixes = null;
        this.myNeedsUpdateOnTyping = null;
        this.myAfterEndOfLine = false;
        this.myIsFileLevelAnnotation = false;
        assert (startOffset <= endOffset) : startOffset + ":" + endOffset;
        assert (startOffset >= 0) : "Start offset must not be negative: " + startOffset;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    public void registerFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation", "registerFix"));
        }
        this.registerFix(fix, null);
    }

    public void registerFix(@NotNull IntentionAction fix, TextRange range) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation", "registerFix"));
        }
        this.registerFix(fix, range, null);
    }

    public void registerFix(@NotNull LocalQuickFix fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation", "registerFix"));
        }
        if (problemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/lang/annotation/Annotation", "registerFix"));
        }
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(new LocalQuickFixAsIntentionAdapter(fix, problemDescriptor), range, key));
    }

    public void registerFix(@NotNull IntentionAction fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation", "registerFix"));
        }
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(fix, range, key));
    }

    public <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull T fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation", "registerBatchFix"));
        }
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myBatchFixes == null) {
            this.myBatchFixes = new ArrayList<QuickFixInfo>();
        }
        this.myBatchFixes.add(new QuickFixInfo(fix, range, key));
    }

    public <T extends IntentionAction & LocalQuickFix> void registerUniversalFix(@NotNull T fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation", "registerUniversalFix"));
        }
        this.registerBatchFix(fix, range, key);
        this.registerFix(fix, range, key);
    }

    public void setNeedsUpdateOnTyping(boolean b) {
        this.myNeedsUpdateOnTyping = b;
    }

    public boolean needsUpdateOnTyping() {
        if (this.myNeedsUpdateOnTyping == null) {
            return this.mySeverity != HighlightSeverity.INFORMATION;
        }
        return this.myNeedsUpdateOnTyping;
    }

    @Override
    public int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getSeverity"));
        }
        return highlightSeverity;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    @NotNull
    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            TextAttributesKey textAttributesKey = this.myEnforcedAttributesKey;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
            }
            return textAttributesKey;
        }
        if (this.myHighlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
            if (this.mySeverity == HighlightSeverity.ERROR) {
                TextAttributesKey textAttributesKey = CodeInsightColors.ERRORS_ATTRIBUTES;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
                }
                return textAttributesKey;
            }
            if (this.mySeverity == HighlightSeverity.WARNING) {
                TextAttributesKey textAttributesKey = CodeInsightColors.WARNINGS_ATTRIBUTES;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
                }
                return textAttributesKey;
            }
            if (this.mySeverity == HighlightSeverity.WEAK_WARNING) {
                TextAttributesKey textAttributesKey = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
                }
                return textAttributesKey;
            }
        }
        if (this.myHighlightType == ProblemHighlightType.GENERIC_ERROR) {
            TextAttributesKey textAttributesKey = CodeInsightColors.ERRORS_ATTRIBUTES;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
            }
            return textAttributesKey;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            TextAttributesKey textAttributesKey = CodeInsightColors.DEPRECATED_ATTRIBUTES;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
            }
            return textAttributesKey;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            TextAttributesKey textAttributesKey = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
            }
            return textAttributesKey;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL || this.myHighlightType == ProblemHighlightType.ERROR) {
            TextAttributesKey textAttributesKey = CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
            }
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = HighlighterColors.TEXT;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/annotation/Annotation", "getTextAttributes"));
        }
        return textAttributesKey;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    @Nullable
    public List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes;
    }

    @Nullable
    public List<QuickFixInfo> getBatchFixes() {
        return this.myBatchFixes;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setHighlightType(ProblemHighlightType highlightType) {
        this.myHighlightType = highlightType;
    }

    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    @NonNls
    public String toString() {
        return "Annotation(message='" + this.myMessage + "'" + ", severity='" + this.mySeverity + "'" + ", toolTip='" + this.myTooltip + "'" + ")";
    }

    public static class QuickFixInfo {
        @NotNull
        public final IntentionAction quickFix;
        @NotNull
        public final TextRange textRange;
        public final HighlightDisplayKey key;

        public QuickFixInfo(@NotNull IntentionAction fix, @NotNull TextRange range, @Nullable HighlightDisplayKey key) {
            if (fix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/lang/annotation/Annotation$QuickFixInfo", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/annotation/Annotation$QuickFixInfo", "<init>"));
            }
            this.key = key;
            this.quickFix = fix;
            this.textRange = range;
        }

        public String toString() {
            return this.quickFix.toString();
        }
    }
}

