/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, final @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        final PsiClass psiClass = p.getPsiClass();
        final List<PsiMethod> methods = ApplicationManager.getApplication().runReadAction(new Computable<List<PsiMethod>>(){

            @Override
            public List<PsiMethod> compute() {
                PsiMethod[] methodsArray = psiClass.getMethods();
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(methodsArray.length);
                for (PsiMethod method : methodsArray) {
                    if (!PsiUtil.canBeOverriden(method)) continue;
                    methods.add(method);
                }
                return methods;
            }
        });
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            @Override
            public boolean process(PsiClass inheritor) {
                PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor(psiClass, inheritor, PsiSubstitutor.EMPTY);
                if (substitutor == null) {
                    return true;
                }
                for (PsiMethod method : methods) {
                    PsiClass superClass;
                    MethodSignature signature;
                    PsiMethod inInheritor;
                    if (method.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(inheritor.getProject()).arePackagesTheSame(psiClass, inheritor) || !((inInheritor = MethodSignatureUtil.findMethodBySuperSignature(inheritor, signature = method.getSignature(substitutor), false)) == null || inInheritor.hasModifierProperty("static") ? psiClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(psiClass, true) && (inInheritor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived(inheritor, superClass, signature, true)) != null && !inInheritor.hasModifierProperty("static") && !consumer.process(Pair.create(method, inInheritor)) : !consumer.process(Pair.create(method, inInheritor)))) continue;
                    return false;
                }
                return true;
            }
        };
        return ClassInheritorsSearch.search(psiClass, scope, true).forEach(inheritorsProcessor);
    }
}

