/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "projectProductionScope"));
        }
        ProductionScopeFilter productionScopeFilter = new ProductionScopeFilter(project);
        if (productionScopeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "projectProductionScope"));
        }
        return productionScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "projectTestScope"));
        }
        TestScopeFilter testScopeFilter = new TestScopeFilter(project);
        if (testScopeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "projectTestScope"));
        }
        return testScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        DirectoryScope directoryScope = new DirectoryScope(directory, withSubdirectories);
        if (directoryScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        DirectoryScope directoryScope = new DirectoryScope(project, directory, withSubdirectories);
        if (directoryScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
        }
        if (directories.length == 1) {
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope(project, directories[0], withSubdirectories);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
            }
            return globalSearchScope;
        }
        BitSet withSubdirectoriesBS = new BitSet(directories.length);
        if (withSubdirectories) {
            withSubdirectoriesBS.set(0, directories.length - 1);
        }
        DirectoriesScope directoriesScope = new DirectoriesScope(project, directories, withSubdirectoriesBS);
        if (directoriesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
        }
        return directoriesScope;
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "filterScope"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/search/GlobalSearchScopesCore", "filterScope"));
        }
        return new FilterScopeAdapter(project, set);
    }

    static class DirectoriesScope
    extends GlobalSearchScope {
        private final VirtualFile[] myDirectories;
        private final BitSet myWithSubdirectories;

        private DirectoriesScope(@NotNull Project project, @NotNull VirtualFile[] directories, @NotNull BitSet withSubdirectories) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "<init>"));
            }
            if (directories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "<init>"));
            }
            if (withSubdirectories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "withSubdirectories", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "<init>"));
            }
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectories = directories;
            if (directories.length < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: " + Arrays.asList(directories));
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "contains"));
            }
            VirtualFile parent = file.getParent();
            return parent != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "in"));
            }
            for (int i = 0; i < this.myDirectories.length; ++i) {
                VirtualFile directory = this.myDirectories[i];
                boolean withSubdirectories = this.myWithSubdirectories.get(i);
                if (!(withSubdirectories ? VfsUtilCore.isAncestor(directory, parent, false) : directory.equals(parent))) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "Directories scope: " + Arrays.asList(this.myDirectories);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.myDirectories.length; ++i) {
                VirtualFile directory = this.myDirectories[i];
                boolean withSubdirectories = this.myWithSubdirectories.get(i);
                result = result * 31 + directory.hashCode() * 31 + (withSubdirectories ? 1 : 0);
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && Arrays.equals(this.myDirectories, ((DirectoriesScope)obj).myDirectories) && this.myWithSubdirectories.equals(((DirectoriesScope)obj).myWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
            }
            if (this.equals(scope)) {
                DirectoriesScope directoriesScope = this;
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoryScope) {
                if (this.in(((DirectoryScope)scope).myDirectory)) {
                    DirectoriesScope directoriesScope = this;
                    if (directoriesScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                    }
                    return directoriesScope;
                }
                VirtualFile[] newDirectories = ArrayUtil.append(this.myDirectories, ((DirectoryScope)scope).myDirectory, VirtualFile.class);
                BitSet newWithSubdirectories = (BitSet)this.myWithSubdirectories.clone();
                newWithSubdirectories.set(this.myDirectories.length, ((DirectoryScope)scope).myWithSubdirectories);
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), newDirectories, newWithSubdirectories);
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoriesScope) {
                DirectoriesScope other = (DirectoriesScope)scope;
                ArrayList<VirtualFile> newDirectories = new ArrayList<VirtualFile>(this.myDirectories.length + other.myDirectories.length);
                newDirectories.addAll(Arrays.asList(other.myDirectories));
                BitSet newWithSubdirectories = (BitSet)this.myWithSubdirectories.clone();
                VirtualFile[] directories = other.myDirectories;
                for (int i = 0; i < directories.length; ++i) {
                    VirtualFile otherDirectory = directories[i];
                    if (this.in(otherDirectory)) continue;
                    newWithSubdirectories.set(newDirectories.size(), other.myWithSubdirectories.get(i));
                    newDirectories.add(otherDirectory);
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), newDirectories.toArray(new VirtualFile[newDirectories.size()]), newWithSubdirectories);
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                }
                return directoriesScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "getProject"));
            }
            return project;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.length == 1) {
                VirtualFile root = this.myDirectories[0];
                String string = "Directory '" + root.getName() + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "getDisplayName"));
                }
                return string;
            }
            String string = "Directories " + StringUtil.join(this.myDirectories, new Function<VirtualFile, String>(){

                @Override
                public String fun(VirtualFile file) {
                    return "'" + file.getName() + "'";
                }
            }, ", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "getDisplayName"));
            }
            return string;
        }
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            if (psiDirectory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        private DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "contains"));
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, file, false) : this.myDirectory.equals(file.getParent());
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int hashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
            }
            if (this.equals(scope)) {
                DirectoryScope directoryScope = this;
                if (directoryScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                }
                return directoryScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                VirtualFile otherDirectory = other.myDirectory;
                if (this.myWithSubdirectories && VfsUtilCore.isAncestor(this.myDirectory, otherDirectory, false)) {
                    DirectoryScope directoryScope = this;
                    if (directoryScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                    }
                    return directoryScope;
                }
                if (other.myWithSubdirectories && VfsUtilCore.isAncestor(otherDirectory, this.myDirectory, false)) {
                    DirectoryScope directoryScope = other;
                    if (directoryScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                    }
                    return directoryScope;
                }
                BitSet newWithSubdirectories = new BitSet();
                newWithSubdirectories.set(0, this.myWithSubdirectories);
                newWithSubdirectories.set(1, other.myWithSubdirectories);
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), new VirtualFile[]{this.myDirectory, otherDirectory}, newWithSubdirectories);
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                }
                return directoriesScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "getProject"));
            }
            return project;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = "Directory '" + this.myDirectory.getName() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "getDisplayName"));
            }
            return string;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private TestScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "<init>"));
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "contains"));
            }
            return this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "isSearchInModuleContent"));
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.test.files", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "getDisplayName"));
            }
            return string;
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "<init>"));
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "contains"));
            }
            return this.myFileIndex.isInSourceContent(file) && !this.myFileIndex.isInTestSourceContent(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "isSearchInModuleContent"));
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.production.files", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "getDisplayName"));
            }
            return string;
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "<init>"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "<init>"));
            }
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "contains"));
            }
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.mySet.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "getDisplayName"));
            }
            return string;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "getProject"));
            }
            return project;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

