/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexedRootsProvider;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private volatile Set<VirtualFile> cachedFiles;
    private volatile Set<VirtualFile> cachedDirectories;
    private volatile IndexedRootsProvider[] myExtensions;

    public AdditionalIndexableFileSet(IndexedRootsProvider ... extensions) {
        this.myExtensions = extensions;
    }

    private Set<VirtualFile> getDirectories() {
        Set<VirtualFile> directories = this.cachedDirectories;
        if (directories == null || AdditionalIndexableFileSet.filesInvalidated(directories) || AdditionalIndexableFileSet.filesInvalidated(this.cachedFiles)) {
            directories = this.collectFilesAndDirectories();
        }
        return directories;
    }

    private THashSet<VirtualFile> collectFilesAndDirectories() {
        THashSet files = new THashSet();
        THashSet directories = new THashSet();
        if (this.myExtensions == null) {
            this.myExtensions = Extensions.getExtensions(IndexedRootsProvider.EP_NAME);
        }
        for (IndexedRootsProvider provider : this.myExtensions) {
            for (VirtualFile file : IndexableSetContributor.getRootsToIndex(provider)) {
                (file.isDirectory() ? directories : files).add((Object)file);
            }
        }
        this.cachedFiles = files;
        this.cachedDirectories = directories;
        return directories;
    }

    public static boolean filesInvalidated(Set<VirtualFile> files) {
        for (VirtualFile file : files) {
            if (file.isValid()) continue;
            return true;
        }
        return false;
    }

    public AdditionalIndexableFileSet() {
    }

    @Override
    public boolean isInSet(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet", "isInSet"));
        }
        return VfsUtilCore.isUnder(file, this.getDirectories()) || this.cachedFiles.contains(file);
    }

    @Override
    public void iterateIndexableFilesIn(@NotNull VirtualFile file, final @NotNull ContentIterator iterator) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet", "iterateIndexableFilesIn"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/indexing/AdditionalIndexableFileSet", "iterateIndexableFilesIn"));
        }
        VfsUtilCore.visitChildrenRecursively(file, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet$1", "visitFile"));
                }
                if (!AdditionalIndexableFileSet.this.isInSet(file)) {
                    return false;
                }
                if (!file.isDirectory()) {
                    iterator.processFile(file);
                }
                return true;
            }
        });
    }
}

