/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IfStatementWithTooManyBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.statement.with.too.many.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/IfStatementWithTooManyBranchesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("if.statement.with.too.many.branches.max.option", new Object[0]), this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("if.statement.with.too.many.branches.problem.descriptor", branchCount);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/IfStatementWithTooManyBranchesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithTooManyBranchesVisitor();
    }

    private class IfStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithTooManyBranchesVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiIfStatement parentStatement;
            PsiStatement elseBranch;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/IfStatementWithTooManyBranchesInspection$IfStatementWithTooManyBranchesVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement && statement.equals(elseBranch = (parentStatement = (PsiIfStatement)parent).getElseBranch())) {
                return;
            }
            int branchCount = this.calculateBranchCount(statement);
            if (branchCount <= IfStatementWithTooManyBranchesInspection.this.m_limit) {
                return;
            }
            this.registerStatementError(statement, branchCount);
        }

        private int calculateBranchCount(PsiIfStatement statement) {
            PsiStatement branch = statement.getElseBranch();
            if (branch == null) {
                return 1;
            }
            if (!(branch instanceof PsiIfStatement)) {
                return 2;
            }
            return 1 + this.calculateBranchCount((PsiIfStatement)branch);
        }
    }
}

