/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;

public class DirectClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.directClassInheritorsSearch");
    public static final DirectClassInheritorsSearch INSTANCE = new DirectClassInheritorsSearch();

    private DirectClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(PsiClass aClass) {
        return DirectClassInheritorsSearch.search(aClass, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(aClass)));
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope, boolean includeAnonymous) {
        return DirectClassInheritorsSearch.search(aClass, scope, includeAnonymous, true);
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope, boolean includeAnonymous, boolean checkInheritance) {
        Query<PsiClass> raw = INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope, includeAnonymous, checkInheritance));
        if (!includeAnonymous) {
            return new FilteredQuery<PsiClass>(raw, new Condition<PsiClass>(){

                @Override
                public boolean value(PsiClass psiClass) {
                    return !(psiClass instanceof PsiAnonymousClass);
                }
            });
        }
        return raw;
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myIncludeAnonymous;
        private final boolean myCheckInheritance;

        public SearchParameters(PsiClass aClass, SearchScope scope, boolean includeAnonymous, boolean checkInheritance) {
            this.myClass = aClass;
            this.myScope = scope;
            this.myIncludeAnonymous = includeAnonymous;
            this.myCheckInheritance = checkInheritance;
        }

        public SearchParameters(PsiClass aClass, SearchScope scope, boolean includeAnonymous) {
            this(aClass, scope, includeAnonymous, true);
        }

        public SearchParameters(PsiClass aClass, SearchScope scope) {
            this(aClass, scope, true);
        }

        public PsiClass getClassToProcess() {
            return this.myClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean includeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }
}

