/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiLock;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    static final int CHECK_CANCELED_DELAY_MILLIS = 10;
    final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static volatile int ourLockedCheckCounter = 0;
    private static final boolean DISABLED = "disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private final ScheduledFuture<?> myCheckCancelledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

        @Override
        public void run() {
            for (ProgressIndicator indicator : nonStandardIndicators) {
                try {
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    CoreProgressManager.this.indicatorCanceled(indicator);
                }
            }
        }
    }, 0L, 10L, TimeUnit.MILLISECONDS);
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator = new THashMap();
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
    static final Set<Thread> threadsUnderCanceledIndicator = ContainerUtil.newConcurrentSet();
    private static final Collection<ProgressIndicator> nonStandardIndicators = ConcurrentHashMultiset.create();

    @Override
    public void dispose() {
        this.myCheckCancelledFuture.cancel(true);
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        ProgressIndicator progress;
        boolean thereIsCanceledIndicator;
        boolean bl = thereIsCanceledIndicator = !threadsUnderCanceledIndicator.isEmpty();
        if (thereIsCanceledIndicator && (progress = this.getProgressIndicator()) != null) {
            try {
                progress.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                if (DISABLED) {
                    return;
                }
                if (Thread.holdsLock(PsiLock.LOCK)) {
                    if (++ourLockedCheckCounter > 10) {
                        ourLockedCheckCounter = 0;
                    }
                }
                ourLockedCheckCounter = 0;
                throw e;
            }
        }
    }

    @Override
    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return this.myCurrentUnsafeProgressCount.get() > 0;
    }

    @Override
    public boolean hasModalProgressIndicator() {
        return this.myCurrentModalProgressCount.get() > 0;
    }

    @Override
    public void runProcess(final @NotNull Runnable process, final ProgressIndicator progress) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcess"));
        }
        this.executeProcessUnderProgress(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        if (progress != null && !progress.isRunning()) {
                            progress.start();
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                    process.run();
                }
                finally {
                    if (progress != null && progress.isRunning()) {
                        progress.stop();
                        if (progress instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)progress).processFinish();
                        }
                    }
                }
            }
        }, progress);
    }

    @Override
    public <T> T runProcess(final @NotNull Computable<T> process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcess"));
        }
        final Ref ref = new Ref();
        this.runProcess(new Runnable(){

            @Override
            public void run() {
                ref.set(process.compute());
            }
        }, progress);
        return ref.get();
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/impl/CoreProgressManager", "executeNonCancelableSection"));
        }
        this.executeProcessUnderProgress(runnable, new NonCancelableIndicator());
    }

    @Override
    public void setCancelButtonText(String cancelButtonText) {
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        final AtomicReference result = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously(new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$4", "run"));
                }
                try {
                    Object compute = process.compute();
                    result.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }
        }, null);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        Task.Modal task = new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$5", "run"));
                }
                process.run();
            }
        };
        return this.runProcessWithProgressSynchronously(task, parentComponent);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, final @NotNull Runnable process, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$6", "run"));
                }
                process.run();
            }

            @Override
            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            @Override
            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }
        });
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "run"));
        }
        if (task.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                new TaskRunnable(task, new EmptyProgressIndicator()).run();
            }
        } else if (task.isModal()) {
            this.runProcessWithProgressSynchronously(task.asModal(), null);
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                this.runProcessWithProgressAsynchronously(backgroundable);
            }
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation, ModalityState.NON_MODAL);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        final TaskRunnable process = new TaskRunnable(task, progressIndicator, continuation);
        TaskContainer action = new TaskContainer(task){

            @Override
            public void run() {
                boolean canceled = false;
                try {
                    ProgressManager.getInstance().runProcess(process, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    canceled = true;
                }
                if (canceled || progressIndicator.isCanceled()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onCancel();
                        }
                    }, modalityState);
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onSuccess();
                        }
                    }, modalityState);
                }
            }
        };
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(action);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    protected boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        boolean result = ((ApplicationEx)ApplicationManager.getApplication()).runProcessWithProgressSynchronously(new TaskContainer(task){

            @Override
            public void run() {
                new TaskRunnable(task, ProgressManager.getInstance().getProgressIndicator()).run();
            }
        }, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        if (result) {
            task.onSuccess();
        } else {
            task.onCancel();
        }
        return result;
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        block12: {
            boolean modal;
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "executeProcessUnderProgress"));
            }
            boolean bl = modal = progress != null && progress.isModal();
            if (modal) {
                this.myCurrentModalProgressCount.incrementAndGet();
            }
            if (progress == null) {
                this.myCurrentUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set;
                ProgressIndicator oldIndicator = null;
                boolean bl2 = set = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set) {
                    Thread currentThread = Thread.currentThread();
                    CoreProgressManager.setCurrentIndicator(currentThread, progress);
                    try {
                        CoreProgressManager.registerIndicatorAndRun(progress, currentThread, oldIndicator, process);
                        break block12;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(currentThread, oldIndicator);
                    }
                }
                process.run();
            }
            finally {
                if (progress == null) {
                    this.myCurrentUnsafeProgressCount.decrementAndGet();
                }
                if (modal) {
                    this.myCurrentModalProgressCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process) {
        boolean isStandard;
        boolean alreadyUnder;
        Object underIndicator;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            underIndicator = threadsUnderIndicator.get(indicator);
            if (underIndicator == null) {
                underIndicator = new SmartHashSet();
                threadsUnderIndicator.put(indicator, (Set<Thread>)underIndicator);
            }
            alreadyUnder = !underIndicator.add((Thread)currentThread);
            isStandard = indicator instanceof StandardProgressIndicator;
            if (!isStandard) {
                nonStandardIndicators.add(indicator);
            }
            if (indicator.isCanceled()) {
                threadsUnderCanceledIndicator.add(currentThread);
            } else {
                threadsUnderCanceledIndicator.remove(currentThread);
            }
        }
        try {
            if (indicator instanceof WrappedProgressIndicator) {
                ProgressIndicator wrappee = ((WrappedProgressIndicator)indicator).getOriginalProgressIndicator();
                assert (wrappee != indicator) : indicator + " wraps itself";
                CoreProgressManager.registerIndicatorAndRun(wrappee, currentThread, oldIndicator, process);
            } else {
                process.run();
            }
            map = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
            synchronized (map2) {
                boolean removed;
                boolean bl = removed = alreadyUnder || underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(indicator);
                }
                if (!isStandard) {
                    nonStandardIndicators.remove(indicator);
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                } else {
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
            }
            throw throwable;
        }
        synchronized (map) {
            boolean removed;
            boolean bl = removed = alreadyUnder || underIndicator.remove(currentThread);
            if (removed && underIndicator.isEmpty()) {
                threadsUnderIndicator.remove(indicator);
            }
            if (!isStandard) {
                nonStandardIndicators.remove(indicator);
            }
            if (oldIndicator != null && oldIndicator.isCanceled()) {
                threadsUnderCanceledIndicator.add(currentThread);
            } else {
                threadsUnderCanceledIndicator.remove(currentThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "indicatorCanceled"));
        }
        Map<ProgressIndicator, Set<Thread>> map = threadsUnderIndicator;
        synchronized (map) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread);
                }
            }
        }
    }

    public static boolean isCanceledThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/progress/impl/CoreProgressManager", "isCanceledThread"));
        }
        return threadsUnderCanceledIndicator.contains(thread);
    }

    @Override
    @NotNull
    public final NonCancelableSection startNonCancelableSection() {
        final ProgressIndicator myOld = ProgressManager.getInstance().getProgressIndicator();
        final Thread currentThread = Thread.currentThread();
        NonCancelableIndicator nonCancelor = new NonCancelableIndicator(){

            @Override
            public void done() {
                CoreProgressManager.setCurrentIndicator(currentThread, myOld);
            }
        };
        CoreProgressManager.setCurrentIndicator(currentThread, nonCancelor);
        NonCancelableIndicator nonCancelableIndicator = nonCancelor;
        if (nonCancelableIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager", "startNonCancelableSection"));
        }
        return nonCancelableIndicator;
    }

    private static void setCurrentIndicator(@NotNull Thread currentThread, ProgressIndicator indicator) {
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "com/intellij/openapi/progress/impl/CoreProgressManager", "setCurrentIndicator"));
        }
        if (indicator == null) {
            currentIndicators.remove(currentThread.getId());
        } else {
            currentIndicators.put(currentThread.getId(), indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/progress/impl/CoreProgressManager", "getCurrentIndicator"));
        }
        return currentIndicators.get(thread.getId());
    }

    protected static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        public TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            this(task, indicator, null);
        }

        public TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish(this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "<init>"));
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "getTask"));
            }
            return task;
        }
    }
}

