/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassOnlyUsedInOnePackageInspection
extends BaseGlobalInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.only.used.in.one.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/ClassOnlyUsedInOnePackageInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/packaging/ClassOnlyUsedInOnePackageInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/packaging/ClassOnlyUsedInOnePackageInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/packaging/ClassOnlyUsedInOnePackageInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/siyeh/ig/packaging/ClassOnlyUsedInOnePackageInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner = refClass.getOwner();
        if (!(owner instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        RefPackage otherPackage = null;
        for (RefClass dependency : dependencies) {
            RefPackage refPackage = RefJavaUtil.getPackage(dependency);
            if (owner == refPackage) {
                return null;
            }
            if (otherPackage == refPackage) continue;
            if (otherPackage == null) {
                otherPackage = refPackage;
                continue;
            }
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            RefPackage refPackage = RefJavaUtil.getPackage(dependent);
            if (owner == refPackage) {
                return null;
            }
            if (otherPackage == refPackage) continue;
            if (otherPackage == null) {
                otherPackage = refPackage;
                continue;
            }
            return null;
        }
        if (otherPackage == null) {
            return null;
        }
        PsiClass aClass = refClass.getElement();
        PsiIdentifier identifier = aClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        String packageName = otherPackage.getName();
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("class.only.used.in.one.package.problem.descriptor", packageName), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }
}

