/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.UrlClassLoader;
import java.net.URL;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CachePoolImpl
implements UrlClassLoader.CachePool {
    private final Map<URL, ClasspathCache.LoaderData> myLoaderIndexCache = ContainerUtil.newConcurrentMap();

    CachePoolImpl() {
    }

    void cacheData(@NotNull URL url, @NotNull ClasspathCache.LoaderData data) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/lang/CachePoolImpl", "cacheData"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/lang/CachePoolImpl", "cacheData"));
        }
        this.myLoaderIndexCache.put(url, data);
    }

    ClasspathCache.LoaderData getCachedData(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/lang/CachePoolImpl", "getCachedData"));
        }
        return this.myLoaderIndexCache.get(url);
    }
}

