/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + StreamApiMigrationInspection.class.getName());

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with stream api" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with stream api";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitForeachStatement(PsiForeachStatement statement) {
                super.visitForeachStatement(statement);
                if (PsiUtil.getLanguageLevel(statement).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiType iteratedValueType;
                    PsiExpression iteratedValue = statement.getIteratedValue();
                    PsiStatement body = statement.getBody();
                    if (iteratedValue != null && body != null && InheritanceUtil.isInheritor(iteratedValueType = iteratedValue.getType(), "java.util.Collection")) {
                        PsiClass iteratorClass = PsiUtil.resolveClassInType(iteratedValueType);
                        LOG.assertTrue(iteratorClass != null);
                        try {
                            ControlFlow controlFlow = ControlFlowFactory.getInstance(holder.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                            int startOffset = controlFlow.getStartOffset(body);
                            int endOffset = controlFlow.getEndOffset(body);
                            Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
                            if (exitPoints.isEmpty()) {
                                List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset);
                                for (PsiVariable variable : usedVariables) {
                                    if (HighlightControlFlowUtil.isEffectivelyFinal(variable, body, null)) continue;
                                    return;
                                }
                                if (ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{body}).isEmpty()) {
                                    if (StreamApiMigrationInspection.isCollectCall(body, statement.getIterationParameter())) {
                                        holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with collect call", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new ReplaceWithCollectCallFix());
                                    } else if (!StreamApiMigrationInspection.isTrivial(body, statement.getIterationParameter())) {
                                        holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with foreach call", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new ReplaceWithForeachCallFix());
                                    }
                                }
                            }
                        }
                        catch (AnalysisCanceledException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isCollectCall(PsiStatement body, PsiParameter parameter) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, ifStatement);
        if (methodCallExpression != null) {
            PsiClass enclosingClass;
            PsiElement resolve;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                if (ReferencesSearch.search(parameter, new LocalSearchScope(qualifierExpression)).findFirst() != null) {
                    return false;
                }
                resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve instanceof PsiVariable && ReferencesSearch.search(resolve, new LocalSearchScope(methodCallExpression.getArgumentList())).findFirst() != null) {
                    return false;
                }
                qualifierClass = PsiUtil.resolveClassInType(qualifierExpression.getType());
            } else if (qualifierExpression == null && PsiUtil.getEnclosingStaticElement(body, enclosingClass = PsiTreeUtil.getParentOfType((PsiElement)body, PsiClass.class)) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor(qualifierClass, false, "java.util.Collection")) {
                PsiExpression[] args;
                while (ifStatement != null && PsiTreeUtil.isAncestor(body, ifStatement, false)) {
                    PsiExpression condition = ifStatement.getCondition();
                    if (condition != null && StreamApiMigrationInspection.isConditionDependsOnUpdatedCollections(condition, qualifierExpression)) {
                        return false;
                    }
                    ifStatement = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiIfStatement.class);
                }
                resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method = ((PsiCallExpression)args[0]).resolveMethod();
                        return method != null && !method.hasTypeParameters() && !StreamApiMigrationInspection.isThrowsCompatible(method);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConditionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return ReferencesSearch.search(collection, new LocalSearchScope(condition)).findFirst() != null;
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return dependsOnCollection[0];
    }

    private static boolean isTrivial(PsiStatement body, PsiParameter parameter) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement != null) {
            return false;
        }
        PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body, new PsiParameter[]{parameter}, StreamApiMigrationInspection.createDefaultConsumerType(parameter.getProject(), parameter));
        if (callExpression == null) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        return method != null && StreamApiMigrationInspection.isThrowsCompatible(method);
    }

    private static boolean isThrowsCompatible(PsiMethod method) {
        return ContainerUtil.find(method.getThrowsList().getReferencedTypes(), new Condition<PsiClassType>(){

            @Override
            public boolean value(PsiClassType type) {
                return !ExceptionUtil.isUncheckedException(type);
            }
        }) != null;
    }

    private static PsiClassType createDefaultConsumerType(Project project, PsiParameter parameter) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope(project));
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, parameter.getType()) : null;
    }

    private static void restoreComments(PsiForeachStatement foreachStatement, PsiStatement body) {
        PsiElement parent = foreachStatement.getParent();
        for (PsiComment comment : PsiTreeUtil.findChildrenOfType(body, PsiComment.class)) {
            parent.addBefore(comment, foreachStatement);
        }
    }

    private static String createFiltersChainText(PsiStatement body, PsiParameter parameter, PsiIfStatement ifStatement) {
        ArrayList<String> filters = new ArrayList<String>();
        while (ifStatement != null && PsiTreeUtil.isAncestor(body, ifStatement, false)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition != null) {
                filters.add(".filter(" + parameter.getName() + " -> " + condition.getText() + ")");
            }
            ifStatement = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiIfStatement.class);
        }
        Collections.reverse(filters);
        return StringUtil.join(filters, "");
    }

    private static String getIteratedValueText(PsiExpression iteratedValue) {
        return iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
    }

    private static PsiIfStatement extractIfStatement(PsiStatement body) {
        PsiStatement thenBranch;
        PsiStatement[] statements;
        PsiIfStatement ifStmt = null;
        if (body instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)body;
        } else if (body instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)body).getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)statements[0];
        }
        if (ifStmt != null && ifStmt.getElseBranch() == null && ifStmt.getCondition() != null && (thenBranch = ifStmt.getThenBranch()) != null) {
            PsiIfStatement deeperThen = StreamApiMigrationInspection.extractIfStatement(thenBranch);
            return deeperThen != null ? deeperThen : ifStmt;
        }
        return null;
    }

    private static PsiMethodCallExpression extractAddCall(PsiStatement body, PsiIfStatement ifStatement) {
        PsiExpression expression;
        if (ifStatement != null) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            return StreamApiMigrationInspection.extractAddCall(thenBranch, null);
        }
        PsiExpressionStatement stmt = null;
        if (body instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                stmt = (PsiExpressionStatement)statements[0];
            }
        } else if (body instanceof PsiExpressionStatement) {
            stmt = (PsiExpressionStatement)body;
        }
        if (stmt != null && (expression = stmt.getExpression()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)expression;
        }
        return null;
    }

    private static class ReplaceWithCollectCallFix
    implements LocalQuickFix {
        private ReplaceWithCollectCallFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with collect" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "getFamilyName"));
            }
            return "Replace with collect";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElementFactory elementFactory;
            PsiExpression qualifierExpression;
            PsiElement result;
            StringBuilder builder;
            PsiStatement body;
            PsiForeachStatement foreachStatement;
            block6: {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "applyFix"));
                }
                foreachStatement = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiForeachStatement.class);
                if (foreachStatement == null) return;
                if (!FileModificationService.getInstance().preparePsiElementForWrite(foreachStatement)) {
                    return;
                }
                body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body == null || iteratedValue == null) return;
                PsiParameter parameter = foreachStatement.getIterationParameter();
                builder = new StringBuilder(StreamApiMigrationInspection.getIteratedValueText(iteratedValue) + ".stream()");
                PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
                PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, ifStatement);
                builder.append(StreamApiMigrationInspection.createFiltersChainText(body, parameter, ifStatement));
                builder.append(ReplaceWithCollectCallFix.createMapperFunctionalExpressionText(project, parameter, methodCallExpression.getArgumentList().getExpressions()[0]));
                builder.append(".collect(java.util.stream.Collectors.");
                result = null;
                try {
                    PsiExpressionList argumentList;
                    PsiExpression initializer;
                    PsiElement resolve;
                    qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
                    elementFactory = JavaPsiFacade.getElementFactory(project);
                    if (!(qualifierExpression instanceof PsiReferenceExpression) || !((resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiVariable) || !(resolve instanceof PsiLocalVariable) || !foreachStatement.equals(PsiTreeUtil.skipSiblingsForward(resolve.getParent(), PsiWhiteSpace.class)) || !((initializer = ((PsiVariable)resolve).getInitializer()) instanceof PsiNewExpression) || (argumentList = ((PsiNewExpression)initializer).getArgumentList()) == null || argumentList.getExpressions().length != 0) break block6;
                    StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                    String callText = builder.toString() + ReplaceWithCollectCallFix.createInitializerReplacementText(initializer) + ")";
                    result = initializer.replace(elementFactory.createExpressionFromText(callText, null));
                    foreachStatement.delete();
                    if (result == null) return;
                }
                catch (Throwable throwable) {
                    if (result == null) throw throwable;
                    CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
                    throw throwable;
                }
                CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
                return;
            }
            StreamApiMigrationInspection.restoreComments(foreachStatement, body);
            String qualifierText = qualifierExpression != null ? qualifierExpression.getText() : "";
            String callText = StringUtil.getQualifiedName(qualifierText, "addAll(" + builder.toString() + "toList()));");
            result = foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
            if (result == null) return;
            CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
        }

        private static String createInitializerReplacementText(PsiExpression initializer) {
            PsiClassType rawType;
            PsiType initializerType = initializer.getType();
            PsiClassType psiClassType = rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
            if (rawType != null && rawType.equalsToText("java.util.ArrayList")) {
                return "toList()";
            }
            if (rawType != null && rawType.equalsToText("java.util.HashSet")) {
                return "toSet()";
            }
            return "toCollection(() -> " + initializer.getText() + ")";
        }

        private static String createMapperFunctionalExpressionText(Project project, PsiParameter parameter, PsiExpression expression) {
            String iteration = "";
            if (!ReplaceWithCollectCallFix.isIdentityMapping(parameter, expression)) {
                iteration = iteration + ".map(";
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
                PsiClass functionClass = psiFacade.findClass("java.util.function.Function", GlobalSearchScope.allScope(project));
                PsiClassType functionalInterfaceType = functionClass != null ? psiFacade.getElementFactory().createType(functionClass, parameter.getType(), expression.getType()) : null;
                PsiCallExpression toConvertCall = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(expression, new PsiParameter[]{parameter}, functionalInterfaceType);
                String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(toConvertCall, functionalInterfaceType, new PsiParameter[]{parameter});
                iteration = methodReferenceText != null ? iteration + methodReferenceText : iteration + parameter.getName() + " -> " + expression.getText();
                iteration = iteration + ")";
            }
            return iteration;
        }

        private static boolean isIdentityMapping(PsiParameter parameter, PsiExpression mapperCall) {
            return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).resolve() == parameter;
        }
    }

    private static class ReplaceWithForeachCallFix
    implements LocalQuickFix {
        private ReplaceWithForeachCallFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with forEach" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getFamilyName"));
            }
            return "Replace with forEach";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(foreachStatement)) {
                    return;
                }
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                    PsiParameter parameter = foreachStatement.getIterationParameter();
                    PsiIfStatement ifStmt = StreamApiMigrationInspection.extractIfStatement(body);
                    StringBuilder buffer = new StringBuilder(StreamApiMigrationInspection.getIteratedValueText(iteratedValue));
                    if (ifStmt != null) {
                        PsiStatement thenBranch = ifStmt.getThenBranch();
                        LOG.assertTrue(thenBranch != null);
                        buffer.append(".stream()");
                        buffer.append(StreamApiMigrationInspection.createFiltersChainText(body, parameter, ifStmt));
                        body = thenBranch;
                    }
                    buffer.append(".forEach(");
                    String functionalExpressionText = ReplaceWithForeachCallFix.createForEachFunctionalExpressionText(project, body, parameter);
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
                    PsiExpressionStatement callStatement = (PsiExpressionStatement)elementFactory.createStatementFromText(buffer.toString() + functionalExpressionText + ");", foreachStatement);
                    callStatement = (PsiExpressionStatement)foreachStatement.replace(callStatement);
                    PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
                    LOG.assertTrue(argumentList != null, callStatement.getText());
                    PsiExpression[] expressions = argumentList.getExpressions();
                    LOG.assertTrue(expressions.length == 1);
                    if (expressions[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions[0]).getFunctionalInterfaceType() == null) {
                        callStatement = (PsiExpressionStatement)callStatement.replace(elementFactory.createStatementFromText(buffer.toString() + "(" + parameter.getText() + ") -> " + ReplaceWithForeachCallFix.wrapInBlock(body) + ");", callStatement));
                    }
                    CodeStyleManager.getInstance(project).reformat(callStatement);
                }
            }
        }

        private static String createForEachFunctionalExpressionText(Project project, PsiStatement body, PsiParameter parameter) {
            PsiClassType functionalType;
            PsiParameter[] parameters;
            PsiStatement bodyBlock;
            PsiCallExpression toConvertCall;
            String methodReferenceText;
            PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock(body);
            if (callExpression != null && (methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(toConvertCall = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(bodyBlock = body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body, parameters = new PsiParameter[]{parameter}, functionalType = StreamApiMigrationInspection.createDefaultConsumerType(project, parameter)), functionalType, parameters)) != null) {
                return methodReferenceText;
            }
            return parameter.getName() + " -> " + ReplaceWithForeachCallFix.wrapInBlock(body);
        }

        private static String wrapInBlock(PsiStatement body) {
            if (body instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)body).getExpression().getText();
            }
            String bodyText = body.getText();
            if (!(body instanceof PsiBlockStatement)) {
                return "{" + bodyText + "}";
            }
            return bodyText;
        }
    }
}

