/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.roots.impl.libraries.JarDirectories;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcher;
import com.intellij.openapi.roots.impl.libraries.JarDirectoryWatcherFactory;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryImpl
extends TraceableDisposable
implements LibraryEx.ModifiableModelEx,
LibraryEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.impl.LibraryImpl");
    @NonNls
    public static final String LIBRARY_NAME_ATTR = "name";
    @NonNls
    public static final String LIBRARY_TYPE_ATTR = "type";
    @NonNls
    public static final String ROOT_PATH_ELEMENT = "root";
    @NonNls
    public static final String ELEMENT = "library";
    @NonNls
    public static final String PROPERTIES_ELEMENT = "properties";
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private static final String EXCLUDED_ROOTS_TAG = "excluded";
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    @Nullable
    private VirtualFilePointerContainer myExcludedRoots;
    private final JarDirectories myJarDirectories;
    private final LibraryImpl mySource;
    private PersistentLibraryKind<?> myKind;
    private LibraryProperties myProperties;
    private final MyRootProviderImpl myRootProvider;
    private final ModifiableRootModel myRootModel;
    private boolean myDisposed;
    private final Disposable myPointersDisposable;
    private final JarDirectoryWatcher myRootsWatcher;

    LibraryImpl(LibraryTable table, Element element, ModifiableRootModel rootModel) throws InvalidDataException {
        this(table, rootModel, null, element.getAttributeValue(LIBRARY_NAME_ATTR), (PersistentLibraryKind)LibraryKind.findById(element.getAttributeValue(LIBRARY_TYPE_ATTR)));
        this.readProperties(element);
        this.myJarDirectories.readExternal(element);
        this.readRoots(element);
        this.myRootsWatcher.updateWatchedRoots();
    }

    LibraryImpl(String name, @Nullable PersistentLibraryKind<?> kind, LibraryTable table, ModifiableRootModel rootModel) {
        this(table, rootModel, null, name, kind);
        if (kind != null) {
            this.myProperties = kind.createDefaultProperties();
        }
    }

    private LibraryImpl(@NotNull LibraryImpl from, LibraryImpl newSource, ModifiableRootModel rootModel) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "<init>"));
        }
        this(from.myLibraryTable, rootModel, newSource, from.myName, from.myKind);
        from.checkDisposed();
        if (from.myKind != null && from.myProperties != null) {
            this.myProperties = this.myKind.createDefaultProperties();
            this.myProperties.loadState(from.myProperties.getState());
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer thisContainer = this.myRoots.get(rootType);
            VirtualFilePointerContainer thatContainer = from.myRoots.get(rootType);
            thisContainer.addAll(thatContainer);
        }
        if (from.myExcludedRoots != null) {
            this.myExcludedRoots = from.myExcludedRoots.clone(this.myPointersDisposable);
        }
        this.myJarDirectories.copyFrom(from.myJarDirectories);
    }

    private LibraryImpl(LibraryTable table, ModifiableRootModel rootModel, LibraryImpl newSource, String name, @Nullable PersistentLibraryKind<?> kind) {
        super(new Throwable());
        this.myJarDirectories = new JarDirectories();
        this.myRootProvider = new MyRootProviderImpl();
        this.myPointersDisposable = Disposer.newDisposable();
        this.myRootsWatcher = JarDirectoryWatcherFactory.getInstance().createWatcher(this.myJarDirectories, this.myRootProvider);
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = newSource;
        this.myKind = kind;
        this.myName = name;
        this.myRoots = this.initRoots();
        Disposer.register(this, this.myRootsWatcher);
    }

    private Set<OrderRootType> getAllRootTypes() {
        HashSet<OrderRootType> rootTypes = new HashSet<OrderRootType>();
        rootTypes.addAll(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            rootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        return rootTypes;
    }

    @Override
    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            this.throwDisposalError("'" + this.myName + "' already disposed:");
        }
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getUrls"));
        }
        this.checkDisposed();
        VirtualFilePointerContainer result = this.myRoots.get(rootType);
        String[] stringArray = result == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result.getUrls();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getFiles"));
        }
        this.checkDisposed();
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        SmartList<VirtualFile> expanded = new SmartList<VirtualFile>();
        for (VirtualFile file : container.getFiles()) {
            if (file.isDirectory() && this.myJarDirectories.contains(rootType, file.getUrl())) {
                LibraryImpl.collectJarFiles(file, expanded, this.myJarDirectories.isRecursive(rootType, file.getUrl()));
                continue;
            }
            expanded.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(expanded);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getFiles"));
        }
        return virtualFileArray;
    }

    public static void collectJarFiles(VirtualFile dir, final List<VirtualFile> container, boolean recursively) {
        VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, recursively ? null : VirtualFileVisitor.ONE_LEVEL_DEEP}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                VirtualFile jarRoot;
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$1", "visitFile"));
                }
                VirtualFile virtualFile = jarRoot = file.isDirectory() ? null : StandardFileSystems.getJarRootForLocalFile(file);
                if (jarRoot != null) {
                    container.add(jarRoot);
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @Override
    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        this.checkDisposed();
        LibraryImpl libraryImpl = new LibraryImpl(this, this, this.myRootModel);
        if (libraryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getModifiableModel"));
        }
        return libraryImpl;
    }

    public Library cloneLibrary(RootModelImpl rootModel) {
        LOG.assertTrue(this.myLibraryTable == null);
        LibraryImpl clone = new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
        clone.myRootsWatcher.updateWatchedRoots();
        return clone;
    }

    @Override
    public List<String> getInvalidRootUrls(OrderRootType type) {
        if (this.myDisposed) {
            return Collections.emptyList();
        }
        List<VirtualFilePointer> pointers = this.myRoots.get(type).getList();
        SmartList<String> invalidPaths = null;
        for (VirtualFilePointer pointer : pointers) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList<String>();
            }
            invalidPaths.add(pointer.getUrl());
        }
        return invalidPaths == null ? Collections.emptyList() : invalidPaths;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        LOG.assertTrue(this.isWritable());
        this.myProperties = properties;
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        MyRootProviderImpl myRootProviderImpl = this.myRootProvider;
        if (myRootProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getRootProvider"));
        }
        return myRootProviderImpl;
    }

    private Map<OrderRootType, VirtualFilePointerContainer> initRoots() {
        Disposer.register(this, this.myPointersDisposable);
        com.intellij.util.containers.HashMap<OrderRootType, VirtualFilePointerContainer> result = new com.intellij.util.containers.HashMap<OrderRootType, VirtualFilePointerContainer>(4);
        for (OrderRootType rootType : this.getAllRootTypes()) {
            result.put(rootType, VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable));
        }
        return result;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.readName(element);
        this.readProperties(element);
        this.readRoots(element);
        this.myJarDirectories.readExternal(element);
        this.myRootsWatcher.updateWatchedRoots();
    }

    private void readProperties(Element element) {
        String typeId = element.getAttributeValue(LIBRARY_TYPE_ATTR);
        if (typeId == null) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById(typeId);
        if (this.myKind == null) {
            return;
        }
        this.myProperties = this.myKind.createDefaultProperties();
        Element propertiesElement = element.getChild(PROPERTIES_ELEMENT);
        if (propertiesElement != null) {
            ComponentSerializationUtil.loadComponentState(this.myProperties, propertiesElement);
        }
    }

    private void readName(Element element) {
        this.myName = element.getAttributeValue(LIBRARY_NAME_ATTR);
    }

    private void readRoots(Element element) throws InvalidDataException {
        for (OrderRootType rootType : this.getAllRootTypes()) {
            Element rootChild = element.getChild(rootType.name());
            if (rootChild == null) continue;
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            roots.readExternal(rootChild, ROOT_PATH_ELEMENT);
        }
        Element excludedRoot = element.getChild(EXCLUDED_ROOTS_TAG);
        if (excludedRoot != null) {
            this.getOrCreateExcludedRoots().readExternal(excludedRoot, ROOT_PATH_ELEMENT);
        }
    }

    private VirtualFilePointerContainer getOrCreateExcludedRoots() {
        if (this.myExcludedRoots == null) {
            this.myExcludedRoots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable);
        }
        return this.myExcludedRoots;
    }

    public static List<OrderRootType> sortRootTypes(Collection<OrderRootType> rootTypes) {
        ArrayList<OrderRootType> allTypes = new ArrayList<OrderRootType>(rootTypes);
        Collections.sort(allTypes, new Comparator<OrderRootType>(){

            @Override
            public int compare(@NotNull OrderRootType o1, @NotNull OrderRootType o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$2", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$2", "compare"));
                }
                return o1.name().compareToIgnoreCase(o2.name());
            }
        });
        return allTypes;
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        this.checkDisposed();
        Element element = new Element(ELEMENT);
        if (this.myName != null) {
            element.setAttribute(LIBRARY_NAME_ATTR, this.myName);
        }
        if (this.myKind != null) {
            Element propertiesElement;
            element.setAttribute(LIBRARY_TYPE_ATTR, this.myKind.getKindId());
            Object state = this.myProperties.getState();
            if (!(state == null || (propertiesElement = XmlSerializer.serialize(state, SERIALIZATION_FILTERS)) == null || propertiesElement.getContent().isEmpty() && propertiesElement.getAttributes().isEmpty())) {
                element.addContent(propertiesElement.setName(PROPERTIES_ELEMENT));
            }
        }
        ArrayList<OrderRootType> storableRootTypes = new ArrayList<OrderRootType>();
        storableRootTypes.addAll(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            storableRootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        for (OrderRootType rootType : LibraryImpl.sortRootTypes(storableRootTypes)) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if (roots.size() == 0 && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            roots.writeExternal(rootTypeElement, ROOT_PATH_ELEMENT);
            element.addContent(rootTypeElement);
        }
        if (this.myExcludedRoots != null && this.myExcludedRoots.size() > 0) {
            Element excluded = new Element(EXCLUDED_ROOTS_TAG);
            this.myExcludedRoots.writeExternal(excluded, ROOT_PATH_ELEMENT);
            element.addContent(excluded);
        }
        this.myJarDirectories.writeExternal(element);
        rootElement.addContent(element);
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.myKind;
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addExcludedRoot"));
        }
        VirtualFilePointerContainer roots = this.getOrCreateExcludedRoots();
        if (roots.findByUrl(url) == null) {
            roots.add(url);
        }
    }

    @Override
    public boolean removeExcludedRoot(@NotNull String url) {
        VirtualFilePointer pointer;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "removeExcludedRoot"));
        }
        if (this.myExcludedRoots != null && (pointer = this.myExcludedRoots.findByUrl(url)) != null) {
            this.myExcludedRoots.remove(pointer);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getExcludedRootUrls() {
        String[] stringArray = this.myExcludedRoots != null ? this.myExcludedRoots.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getExcludedRootUrls"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludedRoots() {
        VirtualFile[] virtualFileArray = this.myExcludedRoots != null ? this.myExcludedRoots.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "getExcludedRoots"));
        }
        return virtualFileArray;
    }

    @Override
    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setKind(PersistentLibraryKind<?> kind) {
        LOG.assertTrue(this.isWritable());
        LOG.assertTrue(this.myKind == null || this.myKind == kind, "Library kind cannot be changed from " + this.myKind + " to " + kind);
        this.myKind = kind;
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
    }

    @Override
    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addRoot"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file);
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.addJarDirectory(url, recursive, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.addJarDirectory(file, recursive, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
        this.myJarDirectories.add(rootType, url, recursive);
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive, @NotNull OrderRootType rootType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "addJarDirectory"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file);
        this.myJarDirectories.add(rootType, file.getUrl(), recursive);
    }

    @Override
    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isJarDirectory"));
        }
        return this.isJarDirectory(url, JarDirectories.DEFAULT_JAR_DIRECTORY_TYPE);
    }

    @Override
    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isJarDirectory"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isJarDirectory"));
        }
        return this.myJarDirectories.contains(rootType, url);
    }

    @Override
    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isValid"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isValid"));
        }
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer fp = container.findByUrl(url);
        return fp != null && fp.isValid();
    }

    @Override
    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "removeRoot"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "removeRoot"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer byUrl = container.findByUrl(url);
        if (byUrl != null) {
            container.remove(byUrl);
            if (this.myExcludedRoots != null) {
                for (String excludedRoot : this.myExcludedRoots.getUrls()) {
                    VirtualFilePointer pointer;
                    if (this.isUnderRoots(excludedRoot) || (pointer = this.myExcludedRoots.findByUrl(excludedRoot)) == null) continue;
                    this.myExcludedRoots.remove(pointer);
                }
            }
            this.myJarDirectories.remove(rootType, url);
            return true;
        }
        return false;
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "isUnderRoots"));
        }
        for (VirtualFilePointerContainer container : this.myRoots.values()) {
            if (!VfsUtilCore.isUnder(url, Arrays.asList(container.getUrls()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootUp"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootUp"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveUp(url);
    }

    @Override
    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootDown"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "moveRootDown"));
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveDown(url);
    }

    @Override
    public boolean isChanged() {
        return !this.mySource.equals(this);
    }

    private boolean areRootsChanged(LibraryImpl that) {
        return !that.equals(this);
    }

    public Library getSource() {
        return this.mySource;
    }

    @Override
    public void commit() {
        this.checkDisposed();
        this.mySource.commit(this);
        Disposer.dispose(this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModel", "com/intellij/openapi/roots/impl/libraries/LibraryImpl", "commit"));
        }
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Comparing.equal(fromModel.myName, this.myName)) {
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this);
            }
        }
        this.myKind = fromModel.getKind();
        this.myProperties = fromModel.myProperties;
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.myJarDirectories.copyFrom(fromModel.myJarDirectories);
            this.myRootsWatcher.updateWatchedRoots();
            this.myRootProvider.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(LibraryImpl fromModel) {
        HashMap<OrderRootType, VirtualFilePointerContainer> clonedRoots = ContainerUtil.newHashMap();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container = entry.getValue();
            VirtualFilePointerContainer clone = container.clone(this.myPointersDisposable);
            clonedRoots.put(rootType, clone);
        }
        this.myRoots.clear();
        this.myRoots.putAll(clonedRoots);
        VirtualFilePointerContainer excludedRoots = fromModel.myExcludedRoots;
        this.myExcludedRoots = excludedRoots != null ? excludedRoots.clone(this.myPointersDisposable) : null;
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container : new THashSet(this.myRoots.values())) {
            container.killAll();
        }
        if (this.myExcludedRoots != null) {
            this.myExcludedRoots.killAll();
        }
        Disposer.dispose(this.myPointersDisposable);
        Disposer.register(this, this.myPointersDisposable);
    }

    @Override
    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)o;
        if (!this.myJarDirectories.equals(library.myJarDirectories)) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(library.myName) : library.myName != null) {
            return false;
        }
        if (this.myRoots != null ? !((Object)this.myRoots).equals(library.myRoots) : library.myRoots != null) {
            return false;
        }
        if (this.myKind != null ? !this.myKind.equals(library.myKind) : library.myKind != null) {
            return false;
        }
        if (this.myProperties != null ? !this.myProperties.equals(library.myProperties) : library.myProperties != null) {
            return false;
        }
        return Comparing.equal(this.myExcludedRoots, library.myExcludedRoots);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myRoots != null ? ((Object)this.myRoots).hashCode() : 0);
        result = 31 * result + this.myJarDirectories.hashCode();
        return result;
    }

    @NonNls
    public String toString() {
        return "Library: name:" + this.myName + "; jars:" + this.myJarDirectories + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    private class MyRootProviderImpl
    extends RootProviderBaseImpl {
        private MyRootProviderImpl() {
        }

        @Override
        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getUrls"));
            }
            LinkedHashSet<String> originalUrls = new LinkedHashSet<String>(Arrays.asList(LibraryImpl.this.getUrls(rootType)));
            for (VirtualFile file : this.getFiles(rootType)) {
                originalUrls.add(file.getUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray(originalUrls);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getUrls"));
            }
            return stringArray;
        }

        @Override
        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getFiles"));
            }
            VirtualFile[] virtualFileArray = LibraryImpl.this.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl", "getFiles"));
            }
            return virtualFileArray;
        }
    }
}

