/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters p, final @NotNull Processor<PsiClass> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        final PsiClass aClass = p.getClassToProcess();
        SearchScope useScope = ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            @Override
            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        String qualifiedName = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return aClass.getQualifiedName();
            }
        });
        final Project project = PsiUtilCore.getProjectInReadAction(aClass);
        if ("java.lang.Object".equals(qualifiedName)) {
            return AllClassesSearch.search(useScope, project).forEach(new Processor<PsiClass>(){

                @Override
                public boolean process(PsiClass psiClass) {
                    if (psiClass.isInterface()) {
                        return consumer.process(psiClass);
                    }
                    final PsiClass superClass = psiClass.getSuperClass();
                    if (superClass != null && "java.lang.Object".equals(ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                        @Override
                        public String compute() {
                            return superClass.getQualifiedName();
                        }
                    }))) {
                        return consumer.process(psiClass);
                    }
                    return true;
                }
            });
        }
        final GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : new EverythingGlobalScope(project);
        final String searchKey = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return aClass.getName();
            }
        });
        if (StringUtil.isEmpty(searchKey)) {
            return true;
        }
        Collection<PsiReferenceList> candidates = ApplicationManager.getApplication().runReadAction(new Computable<Collection<PsiReferenceList>>(){

            @Override
            public Collection<PsiReferenceList> compute() {
                return JavaSuperClassNameOccurenceIndex.getInstance().get(searchKey, project, scope);
            }
        });
        HashMap<String, ArrayList<PsiClass>> classes = new HashMap<String, ArrayList<PsiClass>>();
        for (final PsiReferenceList referenceList : candidates) {
            ProgressIndicatorProvider.checkCanceled();
            final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction(new Computable<PsiElement>(){

                @Override
                public PsiElement compute() {
                    return referenceList.getParent();
                }
            });
            if (!JavaDirectInheritorsSearcher.checkInheritance(p, aClass, psiClass)) continue;
            String fqn = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                @Override
                public String compute() {
                    return psiClass.getQualifiedName();
                }
            });
            ArrayList<PsiClass> list = (ArrayList<PsiClass>)classes.get(fqn);
            if (list == null) {
                list = new ArrayList<PsiClass>();
                classes.put(fqn, list);
            }
            list.add(psiClass);
        }
        for (List sameNamedClasses : classes.values()) {
            if (JavaDirectInheritorsSearcher.processSameNamedClasses(consumer, aClass, sameNamedClasses)) continue;
            return false;
        }
        if (p.includeAnonymous()) {
            Collection<PsiAnonymousClass> anonymousCandidates = ApplicationManager.getApplication().runReadAction(new Computable<Collection<PsiAnonymousClass>>(){

                @Override
                public Collection<PsiAnonymousClass> compute() {
                    return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(searchKey, project, scope);
                }
            });
            for (PsiAnonymousClass psiAnonymousClass : anonymousCandidates) {
                ProgressIndicatorProvider.checkCanceled();
                if (!JavaDirectInheritorsSearcher.checkInheritance(p, aClass, psiAnonymousClass) || consumer.process(psiAnonymousClass)) continue;
                return false;
            }
            boolean isEnum = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    return aClass.isEnum();
                }
            });
            if (isEnum) {
                PsiField[] psiFieldArray;
                for (final PsiField field : psiFieldArray = ApplicationManager.getApplication().runReadAction(new Computable<PsiField[]>(){

                    @Override
                    public PsiField[] compute() {
                        return aClass.getFields();
                    }
                })) {
                    PsiEnumConstantInitializer initializingClass;
                    if (!(field instanceof PsiEnumConstant) || (initializingClass = ApplicationManager.getApplication().runReadAction(new Computable<PsiEnumConstantInitializer>(){

                        @Override
                        public PsiEnumConstantInitializer compute() {
                            return ((PsiEnumConstant)field).getInitializingClass();
                        }
                    })) == null || consumer.process(initializingClass)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkInheritance(final DirectClassInheritorsSearch.SearchParameters p, final PsiClass aClass, final PsiClass candidate) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return !p.isCheckInheritance() || candidate.isInheritor(aClass, false);
            }
        });
    }

    private static boolean processSameNamedClasses(Processor<PsiClass> consumer, PsiClass aClass, List<PsiClass> sameNamedClasses) {
        boolean sameJarClassFound = false;
        VirtualFile jarFile = JavaDirectInheritorsSearcher.getJarFile(aClass);
        if (jarFile != null) {
            for (PsiClass sameNamedClass : sameNamedClasses) {
                boolean fromSameJar = Comparing.equal(JavaDirectInheritorsSearcher.getJarFile(sameNamedClass), jarFile);
                if (!fromSameJar) continue;
                sameJarClassFound = true;
                if (consumer.process(sameNamedClass)) continue;
                return false;
            }
        }
        return sameJarClassFound || ContainerUtil.process(sameNamedClasses, consumer);
    }

    private static VirtualFile getJarFile(final PsiClass aClass) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            @Override
            public VirtualFile compute() {
                return PsiUtil.getJarFile(aClass);
            }
        });
    }
}

