/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentWeakValueHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ConcurrentWeakValueHashMap", "<init>"));
        }
        super(map);
    }

    public ConcurrentWeakValueHashMap() {
    }

    public ConcurrentWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentWeakValueHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakValueHashMap", "createValueReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentWeakValueHashMap", "createValueReference"));
        }
        return new MyWeakReference(key, value, this.myQueue);
    }

    private static class MyWeakReference<K, T>
    extends WeakReference<T>
    implements ConcurrentRefValueHashMap.ValueReference<K, T> {
        private final K key;

        private MyWeakReference(@NotNull K key, @NotNull T referent, @NotNull ReferenceQueue<T> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference", "<init>"));
            }
            if (referent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "q", "com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference", "getKey"));
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

