/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringExpressionHelper {
    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluateExpression"));
        }
        return StringExpressionHelper.evaluateExpression(expression, new com.intellij.util.containers.hash.HashSet<PsiElement>());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression, @NotNull Collection<PsiElement> visited) {
        Pair<PsiElement, String> expr;
        PsiExpression initializer;
        PsiElement resolve;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluateExpression"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluateExpression"));
        }
        visited.add(expression);
        if (expression instanceof PsiLiteralExpression) {
            return StringExpressionHelper.evaluatePsiLiteralExpression(expression);
        }
        if (expression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve).getInitializer()) != null && (expr = StringExpressionHelper.evaluateExpression(initializer, visited)) != null) {
            return expr;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiElement element = ((PsiMethodCallExpression)expression).getMethodExpression().resolve();
            if (element instanceof PsiMethod) {
                PsiCodeBlock body = ((PsiMethod)element).getBody();
                if (body != null) {
                    final HashSet returns = new HashSet();
                    body.accept(new JavaRecursiveElementVisitor(){

                        @Override
                        public void visitClass(PsiClass aClass) {
                        }

                        @Override
                        public void visitLambdaExpression(PsiLambdaExpression expression) {
                        }

                        @Override
                        public void visitReturnStatement(PsiReturnStatement statement) {
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression(psiExpression, visited);
                        if (pair == null) continue;
                        return pair;
                    }
                }
                return StringExpressionHelper.evaluateExpression(element, visited);
            }
            return null;
        }
        Pair<PsiElement, String> constantExpression = StringExpressionHelper.evaluateConstantExpression(expression);
        if (constantExpression != null) {
            return constantExpression;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            return StringExpressionHelper.evaluatePolyadicExpressions(expression, visited, binaryExpression.getLOperand(), binaryExpression.getROperand());
        }
        if (expression instanceof PsiPolyadicExpression) {
            return StringExpressionHelper.evaluatePolyadicExpressions(expression, visited, ((PsiPolyadicExpression)expression).getOperands());
        }
        Collection<? extends PsiElement> elements = DfaUtil.getPossibleInitializationElements(expression);
        for (PsiElement psiElement : elements) {
            Pair<PsiElement, String> expr2;
            if (visited.contains(psiElement) || (expr2 = StringExpressionHelper.evaluateExpression(psiElement)) == null) continue;
            return expr2;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePolyadicExpressions(@NotNull PsiElement expression, @NotNull Collection<PsiElement> visited, PsiExpression ... operands) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluatePolyadicExpressions"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluatePolyadicExpressions"));
        }
        if (operands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operands", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluatePolyadicExpressions"));
        }
        StringBuilder sb = new StringBuilder();
        for (PsiExpression operand : operands) {
            Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression(operand, visited);
            if (pair == null) {
                return null;
            }
            sb.append((String)pair.second);
        }
        return Pair.create(expression, sb.toString());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluatePsiLiteralExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluatePsiLiteralExpression"));
        }
        return Pair.create(expression, ElementManipulators.getValueText(expression));
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateConstantExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "evaluateConstantExpression"));
        }
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance(expression.getProject()).getConstantEvaluationHelper();
        Object result = helper.computeConstantExpression(expression);
        if (result instanceof String) {
            return Pair.create(expression, (String)result);
        }
        return null;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> searchStringExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope, int expNum) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "searchStringExpressions"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "searchStringExpressions"));
        }
        HashSet<Pair<PsiElement, String>> pairs = new HashSet<Pair<PsiElement, String>>();
        for (PsiMethodCallExpression methodCallExpression : StringExpressionHelper.searchMethodCalls(psiMethod, searchScope)) {
            PsiExpression expression;
            Pair<PsiElement, String> pair;
            PsiExpression[] expressions = methodCallExpression.getArgumentList().getExpressions();
            if (expressions.length <= expNum || (pair = StringExpressionHelper.evaluateExpression(expression = expressions[expNum])) == null) continue;
            pairs.add(pair);
        }
        HashSet<Pair<PsiElement, String>> hashSet = pairs;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "searchStringExpressions"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiMethodCallExpression> searchMethodCalls(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "searchMethodCalls"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "searchMethodCalls"));
        }
        HashSet<PsiMethodCallExpression> callExpressions = new HashSet<PsiMethodCallExpression>();
        CommonProcessors.CollectUniquesProcessor consumer = new CommonProcessors.CollectUniquesProcessor();
        MethodReferencesSearch.search(psiMethod, searchScope, true).forEach(consumer);
        for (PsiReference psiReference : consumer.getResults()) {
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression == null) continue;
            callExpressions.add(methodCallExpression);
        }
        HashSet<PsiMethodCallExpression> hashSet = callExpressions;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StringExpressionHelper", "searchMethodCalls"));
        }
        return hashSet;
    }
}

