/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodDeepestSuperSearcher
implements QueryExecutor<PsiMethod, PsiMethod> {
    @Override
    public boolean execute(@NotNull PsiMethod method, @NotNull Processor<PsiMethod> consumer) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/MethodDeepestSuperSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/MethodDeepestSuperSearcher", "execute"));
        }
        return MethodDeepestSuperSearcher.processDeepestSuperMethods(method, consumer);
    }

    public static boolean processDeepestSuperMethods(PsiMethod method, Processor<PsiMethod> consumer) {
        THashSet methods = new THashSet();
        methods.add(method);
        return MethodDeepestSuperSearcher.findDeepestSuperOrSelfSignature(method, (Set<PsiMethod>)methods, null, consumer);
    }

    private static boolean findDeepestSuperOrSelfSignature(final PsiMethod method, Set<PsiMethod> set, Set<PsiMethod> guard, Processor<PsiMethod> processor) {
        if (guard != null && !guard.add((PsiMethod)method)) {
            return true;
        }
        PsiMethod[] supers = ApplicationManager.getApplication().runReadAction(new Computable<PsiMethod[]>(){

            @Override
            public PsiMethod[] compute() {
                return method.findSuperMethods();
            }
        });
        if (supers.length == 0 && set.add(method) && !processor.process(method)) {
            return false;
        }
        for (PsiMethod superMethod : supers) {
            if (guard == null) {
                guard = new THashSet();
                guard.add(method);
            }
            if (MethodDeepestSuperSearcher.findDeepestSuperOrSelfSignature(superMethod, set, (Set<PsiMethod>)guard, processor)) continue;
            return false;
        }
        return true;
    }
}

