/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import org.jetbrains.annotations.NotNull;

public class XmlTextLiteralEscaper
extends LiteralTextEscaper<XmlTextImpl> {
    public XmlTextLiteralEscaper(XmlTextImpl xmlText) {
        super(xmlText);
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/impl/source/tree/injected/XmlTextLiteralEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/intellij/psi/impl/source/tree/injected/XmlTextLiteralEscaper", "decode"));
        }
        int startInDecoded = ((XmlTextImpl)this.myHost).physicalToDisplay(rangeInsideHost.getStartOffset());
        int endInDecoded = ((XmlTextImpl)this.myHost).physicalToDisplay(rangeInsideHost.getEndOffset());
        outChars.append(((XmlTextImpl)this.myHost).getValue(), startInDecoded, endInDecoded);
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int rangeInsideHostEndOffset;
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/impl/source/tree/injected/XmlTextLiteralEscaper", "getOffsetInHost"));
        }
        int rangeInsideHostStartOffset = rangeInsideHost.getStartOffset();
        int displayStart = ((XmlTextImpl)this.myHost).physicalToDisplay(rangeInsideHostStartOffset);
        int i = ((XmlTextImpl)this.myHost).displayToPhysical(offsetInDecoded + displayStart);
        if (i < rangeInsideHostStartOffset) {
            i = rangeInsideHostStartOffset;
        }
        if (i > (rangeInsideHostEndOffset = rangeInsideHost.getEndOffset())) {
            i = rangeInsideHostEndOffset;
        }
        return i;
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        TextRange textRange = ((XmlTextImpl)this.myHost).getCDATAInterior();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/XmlTextLiteralEscaper", "getRelevantTextRange"));
        }
        return textRange;
    }

    @Override
    public boolean isOneLine() {
        return false;
    }
}

