/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.CollectionQueryUpdateCalledVisitor;
import com.siyeh.ig.bugs.ThisPassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MismatchedCollectionQueryUpdateInspectionBase
extends BaseInspection {
    private static final Set<String> QUERY_EXCLUDES = Collections.singleton("java.util.Collections");
    private static final Set<String> UPDATE_EXCLUDES = new HashSet<String>(CollectionUtils.getAllCollectionNames());
    public final ExternalizableStringSet queryNames = new ExternalizableStringSet("copyInto", "drainTo", "parallelStream", "propertyNames", "save", "store", "stream", "write", "forEach", "replaceAll");
    public final ExternalizableStringSet updateNames = new ExternalizableStringSet("add", "clear", "drainTo", "insert", "load", "offer", "poll", "push", "put", "remove", "replace", "retain", "set", "take", "compute");

    private static boolean isEmptyCollectionInitializer(PsiExpression initializer) {
        PsiExpression[] arguments;
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return false;
            }
            if (CollectionUtils.isCollectionClassOrInterface(argumentType)) {
                return false;
            }
            if (!(argumentType instanceof PsiArrayType)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectionQueriedByAssignment(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase", "collectionQueriedByAssignment"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase", "collectionQueriedByAssignment"));
        }
        CollectionQueriedByAssignmentVisitor visitor = new CollectionQueriedByAssignmentVisitor(variable);
        context.accept(visitor);
        return visitor.mayBeQueried();
    }

    @Override
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfCollection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase", "getID"));
        }
        return "MismatchedQueryAndUpdateOfCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.descriptor.updated.not.queried", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.description.queried.not.updated", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedCollectionQueryUpdateVisitor();
    }

    static {
        UPDATE_EXCLUDES.add("java.util.Collections");
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends BaseInspectionVisitor {
        private MismatchedCollectionQueryUpdateVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "visitField"));
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!this.checkVariable(field, containingClass)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated(field, containingClass);
            boolean read = this.collectionContentsAreQueried(field, containingClass);
            if (read == written) {
                return;
            }
            this.registerFieldError(field, written);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!this.checkVariable(variable, codeBlock)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated(variable, codeBlock);
            boolean read = this.collectionContentsAreQueried(variable, codeBlock);
            if (read != written) {
                this.registerVariableError(variable, written);
            }
        }

        private boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type = variable.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private boolean collectionContentsAreUpdated(PsiVariable variable, PsiElement context) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, UPDATE_EXCLUDES, context) || this.collectionUpdateCalled(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer)) {
                return true;
            }
            if (initializer instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)initializer).getAnonymousClass()) != null) {
                if (this.collectionUpdateCalled(null, anonymousClass)) {
                    return true;
                }
                ThisPassedAsArgumentVisitor visitor = new ThisPassedAsArgumentVisitor();
                anonymousClass.accept(visitor);
                if (visitor.isPassed()) {
                    return true;
                }
            }
            return VariableAccessUtils.variableIsAssigned(variable, context);
        }

        private boolean collectionContentsAreQueried(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, QUERY_EXCLUDES, context) || this.collectionQueryCalled(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer)) {
                return true;
            }
            return MismatchedCollectionQueryUpdateInspectionBase.collectionQueriedByAssignment(variable, context);
        }

        private boolean collectionQueryCalled(PsiVariable variable, PsiElement context) {
            CollectionQueryUpdateCalledVisitor visitor = new CollectionQueryUpdateCalledVisitor(variable, MismatchedCollectionQueryUpdateInspectionBase.this.queryNames, true);
            context.accept(visitor);
            return visitor.isQueriedUpdated();
        }

        private boolean collectionUpdateCalled(@Nullable PsiVariable variable, PsiElement context) {
            CollectionQueryUpdateCalledVisitor visitor = new CollectionQueryUpdateCalledVisitor(variable, MismatchedCollectionQueryUpdateInspectionBase.this.updateNames, false);
            context.accept(visitor);
            return visitor.isQueriedUpdated();
        }
    }

    private static class CollectionQueriedByAssignmentVisitor
    extends JavaRecursiveElementVisitor {
        private boolean mayBeQueried;
        @NotNull
        private final PsiVariable variable;

        CollectionQueriedByAssignmentVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$CollectionQueriedByAssignmentVisitor", "<init>"));
            }
            this.mayBeQueried = false;
            this.variable = variable;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$CollectionQueriedByAssignmentVisitor", "visitElement"));
            }
            if (this.mayBeQueried) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.mayBeQueried) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses(expression);
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.PLUS != tokenType) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type = polyadicExpression.getType();
            if (type == null || !type.equalsToText("java.lang.String")) {
                return;
            }
            this.mayBeQueried = true;
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$CollectionQueriedByAssignmentVisitor", "visitAssignmentExpression"));
            }
            if (this.mayBeQueried) {
                return;
            }
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            if (!VariableAccessUtils.mayEvaluateToVariable(lhs, this.variable)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(rhs)) {
                return;
            }
            this.mayBeQueried = true;
        }

        public boolean mayBeQueried() {
            return this.mayBeQueried;
        }
    }
}

