/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneUtils {
    private CloneUtils() {
    }

    public static boolean isCloneable(@Nullable PsiClass aClass) {
        return InheritanceUtil.isInheritor(aClass, "java.lang.Cloneable");
    }

    public static boolean isDirectlyCloneable(@NotNull PsiClass aClass) {
        PsiClass[] interfaces;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/CloneUtils", "isDirectlyCloneable"));
        }
        for (PsiClass anInterface : interfaces = aClass.getInterfaces()) {
            String qualifiedName;
            if (anInterface == null || !"java.lang.Cloneable".equals(qualifiedName = anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClone(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType javaLangObject = !PsiUtil.isLanguageLevel5OrHigher(method) ? TypeUtils.getObjectType(method) : null;
        return MethodUtils.methodMatches(method, null, (PsiType)javaLangObject, "clone", PsiType.EMPTY_ARRAY);
    }

    public static boolean onlyThrowsException(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/CloneUtils", "onlyThrowsException"));
        }
        if (!(method.hasModifierProperty("final") || (aClass = method.getContainingClass()) != null && aClass.hasModifierProperty("final"))) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[statements.length - 1];
        return statement instanceof PsiThrowStatement;
    }
}

