/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    @Override
    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "execute"));
        }
        final PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        String annotationFQN = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return annClass.getQualifiedName();
            }
        });
        assert (annotationFQN != null);
        final PsiManager psiManager = ApplicationManager.getApplication().runReadAction(new Computable<PsiManager>(){

            @Override
            public PsiManager compute() {
                return annClass.getManager();
            }
        });
        SearchScope useScope = p.getScope();
        final Class[] types = p.getTypes();
        for (final PsiAnnotation ann : AnnotatedElementsSearcher.getAnnotationCandidates(annClass, useScope)) {
            PsiModifierListOwner candidate = ApplicationManager.getApplication().runReadAction(new Computable<PsiModifierListOwner>(){

                @Override
                public PsiModifierListOwner compute() {
                    PsiElement parent = ann.getParent();
                    if (!(parent instanceof PsiModifierList)) {
                        return null;
                    }
                    PsiElement owner = parent.getParent();
                    if (!AnnotatedElementsSearcher.isInstanceof(owner, types)) {
                        return null;
                    }
                    PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
                    if (ref == null || !psiManager.areElementsEquivalent(ref.resolve(), annClass)) {
                        return null;
                    }
                    return (PsiModifierListOwner)owner;
                }
            });
            if (candidate == null || consumer.process(candidate)) continue;
            return false;
        }
        return true;
    }

    private static Collection<PsiAnnotation> getAnnotationCandidates(final PsiClass annClass, final SearchScope useScope) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Collection<PsiAnnotation>>(){

            @Override
            public Collection<PsiAnnotation> compute() {
                if (useScope instanceof GlobalSearchScope) {
                    return JavaAnnotationIndex.getInstance().get(annClass.getName(), annClass.getProject(), (GlobalSearchScope)useScope);
                }
                ArrayList<PsiAnnotation> result = ContainerUtil.newArrayList();
                for (PsiElement element : ((LocalSearchScope)useScope).getScope()) {
                    result.addAll(PsiTreeUtil.findChildrenOfType(element, PsiAnnotation.class));
                }
                return result;
            }
        });
    }

    public static boolean isInstanceof(PsiElement owner, Class<? extends PsiModifierListOwner>[] types) {
        for (Class<? extends PsiModifierListOwner> type : types) {
            if (!type.isInstance(owner)) continue;
            return true;
        }
        return false;
    }
}

