/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import java.util.ArrayList;
import java.util.List;

public abstract class SerializationManager {
    protected final List<ObjectStubSerializer> myAllSerializers = new ArrayList<ObjectStubSerializer>();
    private volatile boolean mySerializersLoaded = false;

    public static SerializationManager getInstance() {
        return ApplicationManager.getApplication().getComponent(SerializationManager.class);
    }

    public void registerSerializer(ObjectStubSerializer serializer) {
        this.myAllSerializers.add(serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSerializers() {
        if (this.mySerializersLoaded) {
            return;
        }
        SerializationManager serializationManager = this;
        synchronized (serializationManager) {
            IElementType[] stubElementTypes;
            if (this.mySerializersLoaded) {
                return;
            }
            for (StubElementTypeHolderEP holderEP : Extensions.getExtensions(StubElementTypeHolderEP.EP_NAME)) {
                holderEP.initialize();
            }
            for (IElementType type : stubElementTypes = IElementType.enumerate(new IElementType.Predicate(){

                @Override
                public boolean matches(IElementType type) {
                    return type instanceof StubSerializer;
                }
            })) {
                StubSerializer stubSerializer;
                if (type instanceof IStubFileElementType && ((IStubFileElementType)type).getExternalId().equals(PsiFileStubImpl.TYPE.getExternalId()) || this.myAllSerializers.contains(stubSerializer = (StubSerializer)((Object)type))) continue;
                this.registerSerializer(stubSerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    public abstract String internString(String var1);
}

