/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IgnoredJUnitTestInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("ignored.junit.test.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/IgnoredJUnitTestInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiNamedElement info = (PsiNamedElement)infos[0];
        if (info instanceof PsiClass) {
            String string = InspectionGadgetsBundle.message("ignored.junit.test.classproblem.descriptor", info.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/IgnoredJUnitTestInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("ignored.junit.test.method.problem.descriptor", info.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/IgnoredJUnitTestInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoredJUnitTestVisitor();
    }

    private static class IgnoredJUnitTestVisitor
    extends BaseInspectionVisitor {
        private IgnoredJUnitTestVisitor() {
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiModifierListOwner modifierListOwner = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
            if (!(modifierListOwner instanceof PsiClass) && !(modifierListOwner instanceof PsiMethod)) {
                return;
            }
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null) {
                return;
            }
            PsiElement target = nameReferenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            String qualifiedName = aClass.getQualifiedName();
            if (!"org.junit.Ignore".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)annotation, modifierListOwner);
        }
    }
}

