/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverloadedMethodsWithSameNumberOfParametersInspection
extends BaseInspection {
    public boolean ignoreInconvertibleTypes = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.option", new Object[0]), this, "ignoreInconvertibleTypes");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedMethodsWithSameNumberOfParametersVisitor();
    }

    private class OverloadedMethodsWithSameNumberOfParametersVisitor
    extends BaseInspectionVisitor {
        private OverloadedMethodsWithSameNumberOfParametersVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/OverloadedMethodsWithSameNumberOfParametersInspection$OverloadedMethodsWithSameNumberOfParametersVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, false)) {
                PsiParameterList otherParameterList;
                if (method.equals(sameNameMethod) || parameterCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
                if (OverloadedMethodsWithSameNumberOfParametersInspection.this.ignoreInconvertibleTypes && !this.areParameterTypesConvertible(parameterList, otherParameterList)) {
                    return;
                }
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private boolean areParameterTypesConvertible(PsiParameterList parameterList, PsiParameterList otherParameterList) {
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter[] otherParameters = otherParameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiType otherType;
                PsiType type = parameters[i].getType();
                if (type.isAssignableFrom(otherType = otherParameters[i].getType()) || otherType.isAssignableFrom(type)) continue;
                return false;
            }
            return true;
        }
    }
}

