/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInsideStringBufferAppendInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInsideStringBufferAppendVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceWithChainedAppendFix();
    }

    private static class StringConcatenationInsideStringBufferAppendVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInsideStringBufferAppendVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"append".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!StringConcatenationInsideStringBufferAppendVisitor.isConcatenation(argument)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className)) {
                this.registerMethodCallError(expression, containingClass);
                return;
            }
            Project project = containingClass.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiClass appendableClass = psiFacade.findClass("java.lang.Appendable", GlobalSearchScope.allScope(project));
            if (appendableClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritorOrSelf(containingClass, appendableClass, true)) {
                return;
            }
            this.registerMethodCallError(expression, containingClass);
        }

        private static boolean isConcatenation(PsiExpression expression) {
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return StringConcatenationInsideStringBufferAppendVisitor.isConcatenation(parenthesizedExpression.getExpression());
            }
            if (!(expression instanceof PsiPolyadicExpression)) {
                return false;
            }
            if (PsiUtil.isConstantExpression(expression)) {
                return false;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return false;
            }
            return type.equalsToText("java.lang.String");
        }
    }

    private static class ReplaceWithChainedAppendFix
    extends InspectionGadgetsFix {
        private ReplaceWithChainedAppendFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection$ReplaceWithChainedAppendFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection$ReplaceWithChainedAppendFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
            if (methodCallExpression == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = arguments[0];
            PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(qualifier, argument);
            if (appendExpression == null) {
                return;
            }
            methodCallExpression.replace(appendExpression);
        }
    }
}

