/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandlerBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.vfs.impl.jar.JarHandlerBase");
    protected static final long DEFAULT_LENGTH = 0L;
    protected static final long DEFAULT_TIMESTAMP = -1L;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myRelPathsToEntries;
    private boolean myCorruptedJar;
    protected final String myBasePath;
    private final MyZipHandler myHandler;

    public JarHandlerBase(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "<init>"));
        }
        this.myLock = new Object();
        this.myRelPathsToEntries = new SoftReference<Object>(null);
        this.myCorruptedJar = false;
        this.myBasePath = path;
        this.myHandler = new MyZipHandler(path);
    }

    public File getMirrorFile(@NotNull File originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getMirrorFile"));
        }
        return originalFile;
    }

    @NotNull
    protected File getOriginalFile() {
        File file = new File(this.myBasePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOriginalFile"));
        }
        return file;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "list"));
        }
        EntryInfo parentEntry = this.getEntryInfo(file);
        HashSet<String> names = new HashSet<String>();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.parent != parentEntry) continue;
            names.add(info.shortName);
        }
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "list"));
        }
        return stringArray;
    }

    protected EntryInfo getEntryInfo(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntryInfo"));
        }
        return this.getEntryInfo(this.getRelativePath(file));
    }

    private String getRelativePath(VirtualFile file) {
        String path = file.getPath().substring(this.myBasePath.length() + 1);
        return StringUtil.startsWithChar(path, '/') ? path.substring(1) : path;
    }

    public EntryInfo getEntryInfo(@NotNull String parentPath) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntryInfo"));
        }
        return this.getEntriesMap().get(parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map = SoftReference.dereference(this.myRelPathsToEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myRelPathsToEntries);
                if (map == null) {
                    if (this.myCorruptedJar) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.myHandler.getEntries();
                        }
                        catch (IOException e) {
                            this.myCorruptedJar = true;
                            LOG.warn(e.getMessage() + ": " + this.myBasePath, e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myRelPathsToEntries = new SoftReference<Map<String, EntryInfo>>(Collections.unmodifiableMap(map));
                }
            }
        }
        Map<String, EntryInfo> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntriesMap"));
        }
        return map2;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getLength"));
        }
        if (file.getParent() == null) {
            return this.getOriginalFile().length();
        }
        EntryInfo entry = this.getEntryInfo(file);
        return entry == null ? 0L : entry.length;
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getTimeStamp"));
        }
        if (file.getParent() == null) {
            return this.getOriginalFile().lastModified();
        }
        EntryInfo entry = this.getEntryInfo(file);
        return entry == null ? -1L : entry.timestamp;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "isDirectory"));
        }
        if (file.getParent() == null) {
            return true;
        }
        EntryInfo info = this.getEntryInfo(file);
        return info == null || info.isDirectory;
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "exists"));
        }
        if (file.getParent() == null) {
            return this.getOriginalFile().exists();
        }
        EntryInfo info = this.getEntryInfo(file);
        return info != null;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getAttributes"));
        }
        if (file.getParent() == null) {
            FileAttributes attributes = FileSystemUtil.getAttributes(this.getOriginalFile());
            return attributes == null ? null : new FileAttributes(true, false, false, false, attributes.length, attributes.lastModified, false);
        }
        EntryInfo entry = this.getEntryInfo(file);
        return entry == null ? null : new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getInputStream"));
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getInputStream"));
        }
        return bufferExposingByteArrayInputStream;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
        }
        byte[] byArray = this.myHandler.contentsToByteArray(this.getRelativePath(file));
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
        }
        return byArray;
    }

    public JarFile getJar() {
        try {
            File mirror = this.getMirrorFile(this.getOriginalFile());
            return new MyJarFile(new ZipFile(mirror));
        }
        catch (IOException e) {
            LOG.warn(e.getMessage() + ": " + this.myBasePath, e);
            return null;
        }
    }

    static class MyJarFile
    implements JarFile {
        private final ZipFile myZipFile;

        public MyJarFile(ZipFile zipFile) {
            this.myZipFile = zipFile;
        }

        @Override
        public JarFile.JarEntry getEntry(String name) {
            try {
                ZipEntry entry = this.myZipFile.getEntry(name);
                if (entry != null) {
                    return new MyJarEntry(entry);
                }
            }
            catch (RuntimeException e) {
                LOG.warn("corrupted: " + this.myZipFile.getName(), e);
            }
            return null;
        }

        @Override
        public InputStream getInputStream(JarFile.JarEntry entry) throws IOException {
            return this.myZipFile.getInputStream(((MyJarEntry)entry).myEntry);
        }

        @Override
        public Enumeration<? extends JarFile.JarEntry> entries() {
            return new Enumeration<JarFile.JarEntry>(){
                private final Enumeration<? extends ZipEntry> entries;
                {
                    this.entries = MyJarFile.this.myZipFile.entries();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.entries.hasMoreElements();
                }

                @Override
                public JarFile.JarEntry nextElement() {
                    try {
                        ZipEntry entry = this.entries.nextElement();
                        if (entry != null) {
                            return new MyJarEntry(entry);
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.warn("corrupted: " + MyJarFile.this.myZipFile.getName(), e);
                    }
                    return null;
                }
            };
        }

        @Override
        public ZipFile getZipFile() {
            return this.myZipFile;
        }

        private static class MyJarEntry
        implements JarFile.JarEntry {
            private final ZipEntry myEntry;

            MyJarEntry(ZipEntry entry) {
                this.myEntry = entry;
            }

            @Override
            public String getName() {
                return this.myEntry.getName();
            }

            @Override
            public long getSize() {
                return this.myEntry.getSize();
            }

            @Override
            public long getTime() {
                return this.myEntry.getTime();
            }

            @Override
            public boolean isDirectory() {
                return this.myEntry.isDirectory();
            }
        }
    }

    protected static class EntryInfo {
        protected final EntryInfo parent;
        protected final String shortName;
        protected final boolean isDirectory;
        protected final long length;
        protected final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(EntryInfo parent, @NotNull String shortName, boolean isDirectory, long length, long l) {
            void timestamp;
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase$EntryInfo", "<init>"));
            }
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }

    private static class MyZipHandler
    extends ZipHandler {
        public MyZipHandler(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase$MyZipHandler", "<init>"));
            }
            super(path);
        }

        @NotNull
        public Map<String, EntryInfo> getEntries() throws IOException {
            Map<String, ArchiveHandler.EntryInfo> src = this.createEntriesMap();
            THashMap map = new THashMap();
            map.put("", new EntryInfo(null, "", true, 0L, -1L));
            for (String path : src.keySet()) {
                map.put(path, MyZipHandler.getOrCreate((Map<String, EntryInfo>)map, path, src.get(path)));
            }
            THashMap tHashMap = map;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase$MyZipHandler", "getEntries"));
            }
            return tHashMap;
        }

        private static EntryInfo getOrCreate(Map<String, EntryInfo> map, String path, ArchiveHandler.EntryInfo e) {
            EntryInfo entry = map.get(path);
            if (entry == null) {
                int p = path.lastIndexOf(47);
                String parentPath = p > 0 ? path.substring(0, p) : "";
                entry = new EntryInfo(MyZipHandler.getOrCreate(map, parentPath, e.parent), e.shortName, e.isDirectory, e.length, e.timestamp);
                map.put(path, entry);
            }
            return entry;
        }
    }
}

