/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemVer
implements Comparable<SemVer> {
    private final int myMajor;
    private final int myMinor;
    private final int myPatch;
    private final String myRawVersion;

    public SemVer(@NotNull String rawVersion, int major, int minor, int patch) {
        if (rawVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawVersion", "com/intellij/util/text/SemVer", "<init>"));
        }
        this.myRawVersion = rawVersion;
        this.myMajor = major;
        this.myMinor = minor;
        this.myPatch = patch;
    }

    @NotNull
    public String getRawVersion() {
        String string = this.myRawVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/SemVer", "getRawVersion"));
        }
        return string;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getPatch() {
        return this.myPatch;
    }

    @NotNull
    public String getParsedVersion() {
        String string = this.myMajor + "." + this.myMinor + "." + this.myPatch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/SemVer", "getParsedVersion"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        if (this.myMajor != semVer.myMajor) {
            return false;
        }
        if (this.myMinor != semVer.myMinor) {
            return false;
        }
        return this.myPatch == semVer.myPatch;
    }

    public int hashCode() {
        int result = this.myMajor;
        result = 31 * result + this.myMinor;
        result = 31 * result + this.myPatch;
        return result;
    }

    public String toString() {
        return this.myRawVersion;
    }

    @Nullable
    public static SemVer parseFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/SemVer", "parseFromText"));
        }
        String[] comps = text.split(Pattern.quote("."), 3);
        if (comps.length != 3) {
            return null;
        }
        Integer major = SemVer.toInteger(comps[0]);
        Integer minor = SemVer.toInteger(comps[1]);
        String patchStr = comps[2];
        int dashInd = patchStr.indexOf(45);
        if (dashInd >= 0) {
            patchStr = patchStr.substring(0, dashInd);
        }
        Integer patch = SemVer.toInteger(patchStr);
        if (major != null && minor != null && patch != null) {
            return new SemVer(text, major, minor, patch);
        }
        return null;
    }

    private static Integer toInteger(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/util/text/SemVer", "toInteger"));
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public int compareTo(SemVer other) {
        if (this.getMajor() != other.getMajor()) {
            return this.getMajor() - other.getMajor();
        }
        if (this.getMinor() != other.getMinor()) {
            return this.getMinor() - other.getMinor();
        }
        if (this.getPatch() != other.getPatch()) {
            return this.getPatch() - other.getPatch();
        }
        return 0;
    }
}

