/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.components.impl.BasePathMacroManager");
    private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter(Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(ExpandMacroToPathMap result, String macroName, @Nullable String path) {
        if (path != null) {
            BasePathMacroManager.addFileHierarchyReplacements(result, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), '$' + macroName + '$');
        }
    }

    private static void addFileHierarchyReplacements(ExpandMacroToPathMap result, @Nullable VirtualFile f, String macro) {
        if (f == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, f.getParent(), macro + "/..");
        result.put(macro, StringUtil.trimEnd(f.getPath(), "/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd(FileUtil.toSystemIndependentName(path), "/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty(path) && path.contains("/")) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName(path, '/');
        }
    }

    private static VirtualFileSystem getLocalFileSystem() {
        return VirtualFileManager.getInstance().getFileSystem("file");
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand(entry.getKey(), entry.getValue());
        }
        this.getPathMacros().addMacroExpands(result);
        return result;
    }

    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement(entry.getValue(), entry.getKey());
        }
        this.getPathMacros().addMacroReplacements(result);
        return result;
    }

    @Override
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        return new MyTrackingPathMacroSubstitutor();
    }

    @Override
    public String expandPath(String path) {
        return this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public String collapsePath(@Nullable String path) {
        return this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePathsRecursively(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    @Override
    public String collapsePathsRecursively(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        return this.getReplacePathMap().substituteRecursively(text, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "expandPaths"));
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePaths"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    public PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        return this.myPathMacros;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual(FileUtil.toSystemIndependentName(path1), FileUtil.toSystemIndependentName(path2));
    }

    private class MyTrackingPathMacroSubstitutor
    implements TrackingPathMacroSubstitutor {
        private final String myLock = new String("MyTrackingPathMacroSubstitutor.lock");
        private final MultiMap<String, String> myMacroToComponentNames = MultiMap.createSet();
        private final MultiMap<String, String> myComponentNameToMacros = MultiMap.createSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            String string = this.myLock;
            synchronized (string) {
                this.myMacroToComponentNames.clear();
                this.myComponentNameToMacros.clear();
            }
        }

        @Override
        public String expandPath(String path) {
            return BasePathMacroManager.this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public String collapsePath(@Nullable String path) {
            return BasePathMacroManager.this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void expandPaths(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "expandPaths"));
            }
            BasePathMacroManager.this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void collapsePaths(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "collapsePaths"));
            }
            BasePathMacroManager.this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, false, FILTER);
        }

        public int hashCode() {
            return BasePathMacroManager.this.getExpandMacroMap().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateUnknownMacros(@NotNull Set<String> macros) {
            if (macros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macros", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "invalidateUnknownMacros"));
            }
            String string = this.myLock;
            synchronized (string) {
                for (String macro : macros) {
                    Collection<String> componentNames = this.myMacroToComponentNames.remove(macro);
                    if (ContainerUtil.isEmpty(componentNames)) continue;
                    for (String component : componentNames) {
                        this.myComponentNameToMacros.remove(component);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Collection<String> getComponents(@NotNull Collection<String> macros) {
            if (macros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macros", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "getComponents"));
            }
            String string = this.myLock;
            // MONITORENTER : string
            SmartHashSet result = new SmartHashSet();
            Iterator<String> i$ = macros.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    SmartHashSet smartHashSet = result;
                    // MONITOREXIT : string
                    if (smartHashSet != null) return smartHashSet;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "getComponents"));
                }
                String macro = i$.next();
                result.addAll(this.myMacroToComponentNames.get(macro));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Collection<String> getUnknownMacros(@Nullable String componentName) {
            String string = this.myLock;
            // MONITORENTER : string
            Collection<String> collection = componentName == null ? this.myMacroToComponentNames.keySet() : this.myComponentNameToMacros.get(componentName);
            THashSet tHashSet = ContainerUtil.isEmpty(collection) ? Collections.emptyList() : new THashSet(collection);
            // MONITOREXIT : string
            if (tHashSet != null) return tHashSet;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "getUnknownMacros"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUnknownMacros(@NotNull String componentName, @NotNull Collection<String> unknownMacros) {
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "addUnknownMacros"));
            }
            if (unknownMacros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownMacros", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "addUnknownMacros"));
            }
            if (unknownMacros.isEmpty()) {
                return;
            }
            LOG.debug("Registering unknown macros " + new ArrayList<String>(unknownMacros) + " in component " + componentName);
            String string = this.myLock;
            synchronized (string) {
                for (String unknownMacro : unknownMacros) {
                    this.myMacroToComponentNames.putValue(unknownMacro, componentName);
                }
                this.myComponentNameToMacros.putValues(componentName, unknownMacros);
            }
        }
    }
}

