/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModulePointerImpl;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ModulePointerManagerImpl
extends ModulePointerManager {
    private final Map<String, ModulePointerImpl> myUnresolved = new HashMap<String, ModulePointerImpl>();
    private final Map<Module, ModulePointerImpl> myPointers = new HashMap<Module, ModulePointerImpl>();
    private final Project myProject;

    public ModulePointerManagerImpl(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, new ModuleAdapter(){

            @Override
            public void beforeModuleRemoved(Project project, Module module) {
                ModulePointerManagerImpl.this.unregisterPointer(module);
            }

            @Override
            public void moduleAdded(Project project, Module module) {
                ModulePointerManagerImpl.this.moduleAppears(module);
            }

            @Override
            public void modulesRenamed(Project project, List<Module> modules, Function<Module, String> oldNameProvider) {
                for (Module module : modules) {
                    ModulePointerManagerImpl.this.moduleAppears(module);
                }
            }
        });
    }

    private void moduleAppears(Module module) {
        ModulePointerImpl pointer = this.myUnresolved.remove(module.getName());
        if (pointer != null && pointer.getModule() == null) {
            pointer.moduleAdded(module);
            this.registerPointer(module, pointer);
        }
    }

    private void registerPointer(final Module module, ModulePointerImpl pointer) {
        this.myPointers.put(module, pointer);
        Disposer.register(module, new Disposable(){

            @Override
            public void dispose() {
                ModulePointerManagerImpl.this.unregisterPointer(module);
            }
        });
    }

    private void unregisterPointer(Module module) {
        ModulePointerImpl pointer = this.myPointers.remove(module);
        if (pointer != null) {
            pointer.moduleRemoved(module);
            this.myUnresolved.put(pointer.getModuleName(), pointer);
        }
    }

    @Override
    @NotNull
    public ModulePointer create(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/ModulePointerManagerImpl", "create"));
        }
        ModulePointerImpl pointer = this.myPointers.get(module);
        if (pointer == null) {
            pointer = this.myUnresolved.get(module.getName());
            if (pointer == null) {
                pointer = new ModulePointerImpl(module);
            } else {
                pointer.moduleAdded(module);
            }
            this.registerPointer(module, pointer);
        }
        ModulePointerImpl modulePointerImpl = pointer;
        if (modulePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModulePointerManagerImpl", "create"));
        }
        return modulePointerImpl;
    }

    @Override
    @NotNull
    public ModulePointer create(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/openapi/module/impl/ModulePointerManagerImpl", "create"));
        }
        Module module = ModuleManager.getInstance(this.myProject).findModuleByName(moduleName);
        if (module != null) {
            ModulePointer modulePointer = this.create(module);
            if (modulePointer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModulePointerManagerImpl", "create"));
            }
            return modulePointer;
        }
        ModulePointerImpl pointer = this.myUnresolved.get(moduleName);
        if (pointer == null) {
            pointer = new ModulePointerImpl(moduleName);
            this.myUnresolved.put(moduleName, pointer);
        }
        ModulePointerImpl modulePointerImpl = pointer;
        if (modulePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModulePointerManagerImpl", "create"));
        }
        return modulePointerImpl;
    }
}

