/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements LibraryOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.LibraryOrderEntryImpl");
    private Library myLibrary;
    @Nullable
    private String myLibraryName;
    @Nullable
    private String myLibraryLevel;
    private boolean myExported;
    @NonNls
    static final String ENTRY_TYPE = "library";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String LEVEL_ATTR = "level";
    private final MyOrderEntryLibraryTableListener myLibraryListener;
    @NonNls
    private static final String EXPORTED_ATTR = "exported";

    LibraryOrderEntryImpl(@NotNull Library library, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ENTRY_TYPE, "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        LOG.assertTrue(library.getTable() != null);
        this.myLibrary = library;
        this.addListeners();
        this.init();
    }

    LibraryOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        LOG.assertTrue(ENTRY_TYPE.equals(element.getAttributeValue("type")));
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        this.myScope = DependencyScope.readExternal(element);
        String level = element.getAttributeValue(LEVEL_ATTR);
        String name = element.getAttributeValue(NAME_ATTR);
        if (name == null) {
            throw new InvalidDataException();
        }
        if (level == null) {
            throw new InvalidDataException();
        }
        this.searchForLibrary(name, level);
        this.addListeners();
        this.init();
    }

    private LibraryOrderEntryImpl(@NotNull LibraryOrderEntryImpl that, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        if (that.myLibrary == null) {
            this.myLibraryName = that.myLibraryName;
            this.myLibraryLevel = that.myLibraryLevel;
        } else {
            this.myLibrary = that.myLibrary;
        }
        this.myExported = that.myExported;
        this.myScope = that.myScope;
        this.addListeners();
        this.init();
    }

    public LibraryOrderEntryImpl(@NotNull String name, @NotNull String level, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTR, "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        if (projectRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootManager", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "<init>"));
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        this.searchForLibrary(name, level);
        this.addListeners();
    }

    private void searchForLibrary(@NotNull String name, @NotNull String level) {
        Library library;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "searchForLibrary"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTR, "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "searchForLibrary"));
        }
        if (this.myLibrary != null) {
            return;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, this.getRootModel().getModule().getProject());
        Library library2 = library = libraryTable != null ? libraryTable.getLibraryByName(name) : null;
        if (library == null) {
            this.myLibraryName = name;
            this.myLibraryLevel = level;
            this.myLibrary = null;
        } else {
            this.myLibraryName = null;
            this.myLibraryLevel = null;
            this.myLibrary = library;
        }
    }

    @Override
    public boolean isExported() {
        return this.myExported;
    }

    @Override
    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    @Override
    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "getScope"));
        }
        return dependencyScope;
    }

    @Override
    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "setScope"));
        }
        this.myScope = scope;
    }

    @Override
    @Nullable
    public Library getLibrary() {
        Library library = this.getRootModel().getConfigurationAccessor().getLibrary(this.myLibrary, this.myLibraryName, this.myLibraryLevel);
        if (library != null) {
            return library;
        }
        if (this.myLibrary != null) {
            this.myLibraryName = this.myLibrary.getName();
            this.myLibraryLevel = this.myLibrary.getTable().getTableLevel();
        }
        this.myLibrary = null;
        return null;
    }

    @Override
    public boolean isModuleLevel() {
        return false;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getLibraryName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected RootProvider getRootProvider() {
        return this.myLibrary == null ? null : this.myLibrary.getRootProvider();
    }

    @Override
    public boolean isValid() {
        if (this.isDisposed()) {
            return false;
        }
        Library library = this.getLibrary();
        return library != null && !((LibraryEx)library).isDisposed();
    }

    @Override
    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "accept"));
        }
        return policy.visitLibraryOrderEntry(this, initialValue);
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "cloneEntry"));
        }
        ProjectRootManagerImpl rootManager = ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject());
        LibraryOrderEntryImpl libraryOrderEntryImpl = new LibraryOrderEntryImpl(this, rootModel, rootManager);
        if (libraryOrderEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "cloneEntry"));
        }
        return libraryOrderEntryImpl;
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "writeExternal"));
        }
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String libraryLevel = this.getLibraryLevel();
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        element.setAttribute(NAME_ATTR, this.getLibraryName());
        element.setAttribute(LEVEL_ATTR, libraryLevel);
        rootElement.addContent(element);
    }

    @Override
    @Nullable
    public String getLibraryLevel() {
        if (this.myLibrary != null) {
            LibraryTable table = this.myLibrary.getTable();
            return table.getTableLevel();
        }
        return this.myLibraryLevel;
    }

    @Override
    public String getLibraryName() {
        return this.myLibrary == null ? this.myLibraryName : this.myLibrary.getName();
    }

    private void addListeners() {
        String libraryLevel = this.getLibraryLevel();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(libraryLevel, this.getRootModel().getModule().getProject());
        if (libraryTable != null) {
            this.myProjectRootManagerImpl.addListenerForTable(this.myLibraryListener, libraryTable);
        }
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(this.getLibraryLevel(), this.getRootModel().getModule().getProject());
        if (libraryTable != null) {
            this.myProjectRootManagerImpl.removeListenerForTable(this.myLibraryListener, libraryTable);
        }
    }

    private void afterLibraryAdded(@NotNull Library newLibrary) {
        if (newLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLibrary", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl", "afterLibraryAdded"));
        }
        if (this.myLibrary == null && Comparing.equal(this.myLibraryName, newLibrary.getName())) {
            this.myLibrary = newLibrary;
            this.myLibraryName = null;
            this.myLibraryLevel = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    private void beforeLibraryRemoved(Library library) {
        if (library == this.myLibrary) {
            this.myLibraryName = this.myLibrary.getName();
            this.myLibraryLevel = this.myLibrary.getTable().getTableLevel();
            this.myLibrary = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    private class MyOrderEntryLibraryTableListener
    implements LibraryTable.Listener {
        @Override
        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLibrary", "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl$MyOrderEntryLibraryTableListener", "afterLibraryAdded"));
            }
            LibraryOrderEntryImpl.this.afterLibraryAdded(newLibrary);
        }

        @Override
        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LibraryOrderEntryImpl.ENTRY_TYPE, "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl$MyOrderEntryLibraryTableListener", "afterLibraryRenamed"));
            }
            this.afterLibraryAdded(library);
        }

        @Override
        public void beforeLibraryRemoved(Library library) {
            LibraryOrderEntryImpl.this.beforeLibraryRemoved(library);
        }

        @Override
        public void afterLibraryRemoved(Library library) {
        }
    }
}

