/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + CheckedExceptionCompatibilityConstraint.class.getName());
    private final PsiExpression myExpression;
    private PsiType myT;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        block18: {
            List<PsiClassType> exceptions;
            PsiExpression body;
            if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
                return true;
            }
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), this.myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression;
                PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression, this.myT));
                }
                if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression, this.myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                return false;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(this.myT);
            if (interfaceMethod == null) {
                return false;
            }
            final PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, PsiUtil.resolveGenericsClassInType(this.myT));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                    if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session.isProperType(substitutor.substitute(returnType)))) {
                return false;
            }
            List<PsiType> expectedThrownTypes = ContainerUtil.map(interfaceMethod.getThrowsList().getReferencedTypes(), new Function<PsiType, PsiType>(){

                @Override
                public PsiType fun(PsiType type) {
                    return substitutor.substitute(type);
                }
            });
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type : expectedThrownTypes) {
                if (session.isProperType(type)) continue;
                expectedNonProperThrownTypes.add(type);
            }
            ArrayList<PsiClassType> thrownTypes = new ArrayList<PsiClassType>();
            PsiElement psiElement = body = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body != null && (exceptions = ExceptionUtil.ourThrowsGuard.doPreventingRecursion(this.myExpression, false, new Computable<List<PsiClassType>>(){

                @Override
                public List<PsiClassType> compute() {
                    return ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body});
                }
            })) != null) {
                thrownTypes.addAll(ContainerUtil.filter(exceptions, new Condition<PsiClassType>(){

                    @Override
                    public boolean value(PsiClassType type) {
                        return !ExceptionUtil.isUncheckedException(type);
                    }
                }));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, psiType)) continue;
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, psiType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, psiType));
                    }
                }
                for (PsiType psiType : expectedNonProperThrownTypes) {
                    InferenceVariable variable = session.getInferenceVariable(psiType);
                    LOG.assertTrue(variable != null);
                    variable.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(thrownType), expectedThrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression) {
        return new CheckedExceptionCompatibilityConstraint(expression, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<InferenceVariable> result) {
        session.collectDependencies(returnType, result);
    }
}

