/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CharUsedInArithmeticContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiExpression binaryExpression;
        PsiType type;
        ArrayList<InspectionGadgetsFix> result = new ArrayList<InspectionGadgetsFix>();
        PsiElement expression = (PsiElement)infos[0];
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpression && (type = (binaryExpression = (PsiExpression)parent).getType()) instanceof PsiPrimitiveType && !type.equals(PsiType.CHAR)) {
            String typeText = type.getCanonicalText();
            result.add(new CharUsedInArithmeticContentCastFix(typeText));
        }
        if (!(expression instanceof PsiLiteralExpression)) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()]);
            if (inspectionGadgetsFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection", "buildFixes"));
            }
            return inspectionGadgetsFixArray;
        }
        while (parent instanceof PsiPolyadicExpression) {
            if (ExpressionUtils.hasStringType((PsiExpression)parent)) {
                result.add(new CharUsedInArithmeticContentFix());
                break;
            }
            parent = parent.getParent();
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(new InspectionGadgetsFix[result.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharUsedInArithmeticContextVisitor();
    }

    private static class CharUsedInArithmeticContextVisitor
    extends BaseInspectionVisitor {
        private CharUsedInArithmeticContextVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (ComparisonUtils.isComparisonOperation(tokenType)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            PsiType leftType = operands[0].getType();
            for (int i = 1; i < operands.length; ++i) {
                PsiExpression operand = operands[i];
                PsiType rightType = operand.getType();
                PsiType expressionType = TypeConversionUtil.calcTypeForBinaryExpression(leftType, rightType, tokenType, true);
                if (TypeUtils.isJavaLangString(expressionType)) {
                    return;
                }
                if (PsiType.CHAR.equals(rightType)) {
                    this.registerError((PsiElement)operand, operand);
                }
                if (PsiType.CHAR.equals(leftType) && i == 1) {
                    this.registerError((PsiElement)operands[0], operands[0]);
                }
                leftType = rightType;
            }
        }
    }

    private static class CharUsedInArithmeticContentCastFix
    extends InspectionGadgetsFix {
        private final String typeText;

        CharUsedInArithmeticContentCastFix(String typeText) {
            this.typeText = typeText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.cast.quickfix", this.typeText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentCastFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Insert cast" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentCastFix", "getFamilyName"));
            }
            return "Insert cast";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            String expressionText = expression.getText();
            PsiReplacementUtil.replaceExpression(expression, '(' + this.typeText + ')' + expressionText);
        }
    }

    private static class CharUsedInArithmeticContentFix
    extends InspectionGadgetsFix {
        private CharUsedInArithmeticContentFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object literal = literalExpression.getValue();
            if (!(literal instanceof Character)) {
                return;
            }
            String escaped = StringUtil.escapeStringCharacters(literal.toString());
            PsiReplacementUtil.replaceExpression(literalExpression, '\"' + escaped + '\"');
        }
    }
}

