/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionToolsFactory;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.ex.InspectionToolRegistrar");
    private final List<Factory<InspectionToolWrapper>> myInspectionToolFactories = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myInspectionComponentsLoaded = false;

    private synchronized void ensureInitialized() {
        if (!this.myInspectionComponentsLoaded) {
            this.myInspectionComponentsLoaded = true;
            THashSet providers = new THashSet();
            ContainerUtil.addAll(providers, ApplicationManager.getApplication().getComponents(InspectionToolProvider.class));
            ContainerUtil.addAll(providers, Extensions.getExtensions(InspectionToolProvider.EXTENSION_POINT_NAME));
            ArrayList<Factory<InspectionToolWrapper>> factories = new ArrayList<Factory<InspectionToolWrapper>>();
            InspectionToolRegistrar.registerTools((Collection<InspectionToolProvider>)providers, factories);
            for (final LocalInspectionEP localInspectionEP : Extensions.getExtensions(LocalInspectionEP.LOCAL_INSPECTION)) {
                factories.add(new Factory<InspectionToolWrapper>(){

                    @Override
                    public InspectionToolWrapper create() {
                        return new LocalInspectionToolWrapper(localInspectionEP);
                    }
                });
            }
            for (final InspectionEP inspectionEP : Extensions.getExtensions(InspectionEP.GLOBAL_INSPECTION)) {
                factories.add(new Factory<InspectionToolWrapper>(){

                    @Override
                    public InspectionToolWrapper create() {
                        return new GlobalInspectionToolWrapper(inspectionEP);
                    }
                });
            }
            for (InspectionToolsFactory inspectionToolsFactory : Extensions.getExtensions(InspectionToolsFactory.EXTENSION_POINT_NAME)) {
                for (final InspectionProfileEntry profileEntry : inspectionToolsFactory.createTools()) {
                    factories.add(new Factory<InspectionToolWrapper>(){

                        @Override
                        public InspectionToolWrapper create() {
                            return InspectionToolRegistrar.wrapTool(profileEntry);
                        }
                    });
                }
            }
            this.myInspectionToolFactories.addAll(factories);
        }
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileEntry", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
        }
        if (profileEntry instanceof LocalInspectionTool) {
            LocalInspectionToolWrapper localInspectionToolWrapper = new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
            if (localInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return localInspectionToolWrapper;
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            GlobalInspectionToolWrapper globalInspectionToolWrapper = new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
            if (globalInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return globalInspectionToolWrapper;
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    private static void registerTools(@NotNull Collection<InspectionToolProvider> providers, @NotNull List<Factory<InspectionToolWrapper>> factories) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        for (InspectionToolProvider provider : providers) {
            Class[] classes;
            for (final Class aClass : classes = provider.getInspectionClasses()) {
                Factory<InspectionToolWrapper> factory = new Factory<InspectionToolWrapper>(){

                    @Override
                    public InspectionToolWrapper create() {
                        return InspectionToolRegistrar.wrapTool((InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(aClass));
                    }
                };
                factories.add(factory);
            }
        }
    }

    public static InspectionToolRegistrar getInstance() {
        return ServiceManager.getService(InspectionToolRegistrar.class);
    }

    @NotNull
    public List<InspectionToolWrapper> createTools() {
        this.ensureInitialized();
        ArrayList<InspectionToolWrapper> tools = new ArrayList<InspectionToolWrapper>(this.myInspectionToolFactories.size());
        for (Factory<InspectionToolWrapper> factory : this.myInspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = factory.create();
            if (toolWrapper == null || InspectionToolRegistrar.checkTool(toolWrapper) != null) continue;
            tools.add(toolWrapper);
        }
        ArrayList<InspectionToolWrapper> arrayList = tools;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "createTools"));
        }
        return arrayList;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "checkTool"));
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message = null;
        try {
            String id = toolWrapper.getID();
            if (id == null || !LocalInspectionTool.isValidID(id)) {
                message = InspectionsBundle.message("inspection.disabled.wrong.id", toolWrapper.getShortName(), id, "[a-zA-Z_0-9.-]+");
            }
        }
        catch (Throwable t) {
            message = InspectionsBundle.message("inspection.disabled.error", toolWrapper.getShortName(), t.getMessage());
        }
        if (message != null) {
            LOG.error(message);
        }
        return message;
    }
}

