/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand = null;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount = 0;

    @Override
    public void executeCommand(@NotNull Runnable runnable, String name, Object groupId) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(null, runnable, name, groupId);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable runnable, String name, Object groupId, Document document) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    @Override
    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project, name, groupId, confirmationPolicy, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(project, this.myCurrentCommand, throwable);
        }
    }

    @Override
    @Nullable
    public Object startCommand(Project project, @Nls String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null;
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    @Override
    public void finishCommand(Project project, Object command, Throwable throwable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, "no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myDocument);
        try {
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.beforeCommandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
        finally {
            this.myCurrentCommand = null;
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.commandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
    }

    @Override
    public void enterModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push(currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null, "Command must not run: " + String.valueOf(this.myCurrentCommand));
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    @Override
    public void setCurrentCommandName(String name) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name;
    }

    @Override
    public void setCurrentCommandGroupId(Object groupId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId;
    }

    @Override
    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Override
    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    @Override
    public void addCommandListener(@NotNull CommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addCommandListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void addCommandListener(final @NotNull CommandListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addCommandListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addCommandListener"));
        }
        this.addCommandListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                CoreCommandProcessor.this.removeCommandListener(listener);
            }
        });
    }

    @Override
    public void removeCommandListener(@NotNull CommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/command/impl/CoreCommandProcessor", "removeCommandListener"));
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void runUndoTransparentAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/command/impl/CoreCommandProcessor", "runUndoTransparentAction"));
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.fireUndoTransparentStarted();
        }
        try {
            action.run();
        }
        finally {
            if (--this.myUndoTransparentCount == 0) {
                this.fireUndoTransparentFinished();
            }
        }
    }

    @Override
    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    @Override
    public void markCurrentCommandAsGlobal(Project project) {
    }

    @Override
    public void addAffectedDocuments(Project project, Document ... docs) {
        if (docs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docs", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addAffectedDocuments"));
        }
    }

    @Override
    public void addAffectedFiles(Project project, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addAffectedFiles"));
        }
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent(this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myDocument);
        for (CommandListener listener : this.myListeners) {
            try {
                listener.commandStarted(event);
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentStarted() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionStarted();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentFinished() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionFinished();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private static class CommandDescriptor {
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;

        public CommandDescriptor(Runnable command, Project project, String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
            this.myCommand = command;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myDocument = document;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }
    }
}

