/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.PsiUtil;
import java.util.List;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            return false;
        }
        PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
        if (lambdaParameters.length != parameters.length) {
            return false;
        }
        if (this.myExpression.hasFormalParameterTypes()) {
            for (int i = 0; i < lambdaParameters.length; ++i) {
                constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), substitutor.substitute(parameters[i].getType())));
            }
            constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
        } else {
            for (PsiParameter parameter : parameters) {
                if (session.isProperType(session.substituteWithInferenceVariables(substitutor.substitute(parameter.getType())))) continue;
                return false;
            }
        }
        PsiType returnType = interfaceMethod.getReturnType();
        if (returnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            if (returnType.equals(PsiType.VOID)) {
                if (!this.myExpression.isVoidCompatible()) {
                    return false;
                }
            } else {
                if (!this.myExpression.isValueCompatible()) {
                    return false;
                }
                InferenceSession callsession = session.findNestedCallSession(this.myExpression);
                if (!callsession.isProperType(returnType = callsession.substituteWithInferenceVariables(substitutor.substitute(returnType)))) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType));
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

