/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileChunkKey;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.PersistentBTreeEnumerator;
import gnu.trove.TLongArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CompressedAppendableFile {
    private final File myBaseFile;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private long[] myChunkLengthTable;
    private long myFileLength;
    private long myUncompressedFileLength = -1L;
    protected final int myAppendBufferLength;
    private static final int myMinAppendBufferLength = 1024;
    public static final String INCOMPLETE_CHUNK_LENGTH_FILE_EXTENSION = ".s";
    private final LowMemoryWatcher myLowMemoryWatcher;
    private static final FileChunkReadCache ourDecompressedCache = new FileChunkReadCache();

    public CompressedAppendableFile(File file) {
        this(file, PersistentBTreeEnumerator.PAGE_SIZE);
    }

    private CompressedAppendableFile(File file, int bufferSize) {
        this.myBaseFile = file;
        this.myAppendBufferLength = bufferSize;
        this.myLowMemoryWatcher = LowMemoryWatcher.register(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompressedAppendableFile compressedAppendableFile = CompressedAppendableFile.this;
                synchronized (compressedAppendableFile) {
                    CompressedAppendableFile.this.force();
                    CompressedAppendableFile.access$002(CompressedAppendableFile.this, null);
                    CompressedAppendableFile.access$102(CompressedAppendableFile.this, null);
                    CompressedAppendableFile.this.myBufferPosition = 0;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <Data> Data read(long addr, KeyDescriptor<Data> descriptor) throws IOException {
        DataInputStream stream = this.getStream(addr);
        try {
            Object t = descriptor.read(stream);
            return (Data)t;
        }
        finally {
            stream.close();
        }
    }

    @NotNull
    public synchronized DataInputStream getStream(long addr) throws IOException {
        this.initChunkLengthTable();
        this.loadAppendBuffer();
        DataInputStream dataInputStream = new DataInputStream(new SegmentedChunkInputStream(addr, this.myChunkLengthTable, this.myNextChunkBuffer, this.myBufferPosition));
        if (dataInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getStream"));
        }
        return dataInputStream;
    }

    protected File getChunkLengthFile() {
        return new File(this.myBaseFile.getPath() + INCOMPLETE_CHUNK_LENGTH_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        File chunkLengthFile = this.getChunkLengthFile();
        if (chunkLengthFile.exists()) {
            DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new FileInputStream(chunkLengthFile), 32768));
            try {
                TLongArrayList segmentTable = new TLongArrayList();
                long position = 0L;
                while (chunkLengthStream.available() != 0) {
                    int segmentSize = DataInputOutputUtil.readINT(chunkLengthStream);
                    segmentTable.add(position += (long)segmentSize);
                }
                this.myChunkLengthTable = segmentTable.toNativeArray();
                this.myFileLength = this.myChunkLengthTable[this.myChunkLengthTable.length - 1];
            }
            finally {
                try {
                    chunkLengthStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.myChunkLengthTable = ArrayUtil.EMPTY_LONG_ARRAY;
        this.myFileLength = 0L;
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = this.getIncompleteChunkFile().length();
            this.myUncompressedFileLength = (long)this.myChunkLengthTable.length * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized byte[] loadChunk(int chunkNumber) {
        try {
            if (this.myChunkLengthTable == null) {
                this.initChunkLengthTable();
            }
            assert (chunkNumber < this.myChunkLengthTable.length);
            DataInputStream keysStream = this.getChunkStream(this.getChunksFile(), chunkNumber);
            try {
                if (keysStream.available() > 0) {
                    byte[] decompressedBytes = this.decompress(keysStream);
                    if (decompressedBytes.length != this.myAppendBufferLength) assert (false);
                    byte[] byArray = decompressedBytes;
                    return byArray;
                }
            }
            finally {
                try {
                    keysStream.close();
                }
                catch (IOException iOException) {}
            }
            assert (false);
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private DataInputStream getChunkStream(File appendFile, int pageNumber) throws IOException {
        int limit;
        long offset;
        assert (this.myFileLength != 0L);
        if (pageNumber > 0) {
            offset = this.myChunkLengthTable[pageNumber - 1];
            limit = (int)((pageNumber < this.myChunkLengthTable.length ? this.myChunkLengthTable[pageNumber] : this.myFileLength) - offset);
        } else {
            offset = 0L;
            limit = (int)(pageNumber < this.myChunkLengthTable.length ? this.myChunkLengthTable[pageNumber] : this.myFileLength);
        }
        DataInputStream dataInputStream = new DataInputStream(this.getChunkInputStream(appendFile, offset, limit));
        if (dataInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getChunkStream"));
        }
        return dataInputStream;
    }

    @NotNull
    protected InputStream getChunkInputStream(File appendFile, long offset, int pageSize) throws IOException {
        FileInputStream in = new FileInputStream(appendFile);
        if (offset > 0L) {
            in.skip(offset);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new LimitedInputStream(in, pageSize){

            @Override
            public int available() throws IOException {
                return this.remainingLimit();
            }
        }, 32768);
        if (bufferedInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getChunkInputStream"));
        }
        return bufferedInputStream;
    }

    public synchronized <Data> void append(Data value, KeyDescriptor<Data> descriptor) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        descriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        this.append(buffer, size);
    }

    public synchronized void append(byte[] buffer, int size) throws IOException {
        int bytesToWriteInTheBuffer;
        int newBufferSize;
        if (size == 0) {
            return;
        }
        if (this.myNextChunkBuffer == null) {
            this.loadAppendBuffer();
        }
        if ((newBufferSize = this.calcBufferSize(this.myBufferPosition + size)) != this.myNextChunkBuffer.length) {
            this.myNextChunkBuffer = Arrays.copyOf(this.myNextChunkBuffer, newBufferSize);
        }
        int bufferPosition = 0;
        for (int sizeToWrite = size; sizeToWrite > 0; sizeToWrite -= bytesToWriteInTheBuffer) {
            bytesToWriteInTheBuffer = Math.min(this.myNextChunkBuffer.length - this.myBufferPosition, sizeToWrite);
            System.arraycopy(buffer, bufferPosition, this.myNextChunkBuffer, this.myBufferPosition, bytesToWriteInTheBuffer);
            this.myBufferPosition += bytesToWriteInTheBuffer;
            bufferPosition += bytesToWriteInTheBuffer;
            this.saveNextChunkIfNeeded();
        }
        this.myUncompressedFileLength += (long)size;
        this.myDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadAppendBuffer() throws IOException {
        if (this.myNextChunkBuffer != null) {
            return;
        }
        this.myNextChunkBuffer = new byte[this.myAppendBufferLength];
        File tempAppendFile = this.getIncompleteChunkFile();
        if (tempAppendFile.exists()) {
            this.myBufferPosition = (int)tempAppendFile.length();
            this.myNextChunkBuffer = new byte[this.calcBufferSize(this.myBufferPosition)];
            FileInputStream stream = new FileInputStream(tempAppendFile);
            try {
                stream.read(this.myNextChunkBuffer, 0, this.myBufferPosition);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.myBufferPosition = 0;
        this.myNextChunkBuffer = new byte[1024];
    }

    private int calcBufferSize(int position) {
        return Math.min(this.myAppendBufferLength, Integer.highestOneBit(Math.max(1023, position)) << 1);
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            this.saveChunk(compressedOut, this.myFileLength);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            long[] newSegmentTable = new long[this.myChunkLengthTable.length + 1];
            System.arraycopy(this.myChunkLengthTable, 0, newSegmentTable, 0, this.myChunkLengthTable.length);
            newSegmentTable[this.myChunkLengthTable.length] = this.myFileLength;
            this.myChunkLengthTable = newSegmentTable;
            byte[] bytes = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes, 0, this.myAppendBufferLength);
            ourDecompressedCache.put(this, this.myChunkLengthTable.length - 1, bytes);
        }
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    protected byte[] decompress(DataInputStream keysStream) throws IOException {
        return CompressionUtil.readCompressedWithoutOriginalBufferLength(keysStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile(), true)));
        try {
            stream.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        DataOutputStream chunkLengthStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile(), true)));
        try {
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
        finally {
            try {
                chunkLengthStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    protected File getChunksFile() {
        File file = new File(this.myBaseFile.getPath() + ".a");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getChunksFile"));
        }
        return file;
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myBufferPosition != 0 && this.myDirty) {
            block10: {
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition == 0) break block10;
                    BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.getIncompleteChunkFile()));
                    try {
                        stream.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private File getIncompleteChunkFile() {
        File file = new File(this.myBaseFile.getPath() + ".at");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile", "getIncompleteChunkFile"));
        }
        return file;
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
    }

    public synchronized long length() {
        if (this.myUncompressedFileLength == -1L && this.myChunkLengthTable == null) {
            try {
                this.initChunkLengthTable();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.myUncompressedFileLength;
    }

    static /* synthetic */ long[] access$002(CompressedAppendableFile x0, long[] x1) {
        x0.myChunkLengthTable = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(CompressedAppendableFile x0, byte[] x1) {
        x0.myNextChunkBuffer = x1;
        return x1;
    }

    private class SegmentedChunkInputStream
    extends InputStream {
        private final long myAddr;
        private final long[] myChunkLengthTableSnapshot;
        private final byte[] myNextChunkBufferSnapshot;
        private final int myBufferPositionSnapshot;
        private InputStream bytesFromCompressedBlock;
        private InputStream bytesFromTempAppendBlock;
        private int myCurrentPageNumber;
        private int myPageOffset;

        public SegmentedChunkInputStream(long addr, long[] ref, byte[] tableRef, int position) {
            this.myAddr = addr;
            this.myChunkLengthTableSnapshot = ref;
            this.myNextChunkBufferSnapshot = tableRef;
            this.myBufferPositionSnapshot = position;
            this.myCurrentPageNumber = (int)(this.myAddr / (long)CompressedAppendableFile.this.myAppendBufferLength);
            this.myPageOffset = (int)(this.myAddr % (long)CompressedAppendableFile.this.myAppendBufferLength);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.bytesFromCompressedBlock == null) {
                byte[] decompressedBytes = this.myCurrentPageNumber < this.myChunkLengthTableSnapshot.length ? ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber) : ArrayUtil.EMPTY_BYTE_ARRAY;
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, this.myPageOffset, decompressedBytes.length);
            }
            int readBytesCount = 0;
            if (this.bytesFromCompressedBlock.available() > 0) {
                readBytesCount = this.bytesFromCompressedBlock.read(b, off, len);
                this.myPageOffset += readBytesCount;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if (readBytesCount == len) {
                    return readBytesCount;
                }
            }
            while (this.myCurrentPageNumber < this.myChunkLengthTableSnapshot.length) {
                byte[] decompressedBytes = ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber);
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, 0, decompressedBytes.length);
                int read = this.bytesFromCompressedBlock.read(b, off + readBytesCount, len - readBytesCount);
                this.myPageOffset += read;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if ((readBytesCount += read) != len) continue;
                return readBytesCount;
            }
            if (this.bytesFromTempAppendBlock == null) {
                this.bytesFromTempAppendBlock = new ByteArrayInputStream(this.myNextChunkBufferSnapshot, this.myPageOffset, this.myBufferPositionSnapshot);
            }
            return readBytesCount + this.bytesFromTempAppendBlock.read(b, off + readBytesCount, len - readBytesCount);
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[]{0};
            int read = this.read(buf);
            if (read == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }
    }

    private static class FileChunkReadCache
    extends SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> {
        private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileChunkReadCache fileChunkReadCache = FileChunkReadCache.this;
                synchronized (fileChunkReadCache) {
                    FileChunkReadCache.this.clear();
                }
            }
        });
        private final FileChunkKey<CompressedAppendableFile> myKey = new FileChunkKey<Object>(null, 0L);

        public FileChunkReadCache() {
            super(64, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public byte[] get(CompressedAppendableFile file, int page) {
            FileChunkReadCache fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.myKey.setup(file, page);
            byte[] bytes = (byte[])this.get(this.myKey);
            if (bytes != null) {
                // MONITOREXIT : fileChunkReadCache
                if (bytes != null) return bytes;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache", "get"));
            }
            // MONITOREXIT : fileChunkReadCache
            bytes = file.loadChunk(page);
            fileChunkReadCache = this;
            // MONITORENTER : fileChunkReadCache
            this.put(file, page, bytes);
            // MONITOREXIT : fileChunkReadCache
            if (bytes != null) return bytes;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CompressedAppendableFile$FileChunkReadCache", "get"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(CompressedAppendableFile file, long page, byte[] bytes) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file, page);
                this.put(this.myKey, bytes);
            }
        }
    }
}

