/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableUsedInArrayInitializerVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    public VariableUsedInArrayInitializerVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableUsedInArrayInitializerVisitor", "<init>"));
        }
        this.passed = false;
        this.variable = variable;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableUsedInArrayInitializerVisitor", "visitElement"));
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        if (this.passed) {
            return;
        }
        super.visitArrayInitializerExpression(expression);
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) continue;
            this.passed = true;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

