/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(file="$APP_CONFIG$/path.macros.xml", roamingType=RoamingType.PER_PLATFORM)})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PathMacrosImpl.class);
    private final Map<String, String> myLegacyMacros = new HashMap<String, String>();
    private final Map<String, String> myMacros = new LinkedHashMap<String, String>();
    private int myModificationStamp = 0;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final List<String> myIgnoredMacros = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final String MACRO_ELEMENT = "macro";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    @NonNls
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    @NonNls
    public static final String APPLICATION_HOME_MACRO_NAME = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    @NonNls
    public static final String USER_HOME_MACRO_NAME = "USER_HOME";
    private static final Set<String> SYSTEM_MACROS = new HashSet<String>();
    @NonNls
    public static final String EXT_FILE_NAME = "path.macros";
    private static final Set<String> ourToolsMacros;

    public static PathMacrosImpl getInstanceEx() {
        return (PathMacrosImpl)PathMacrosImpl.getInstance();
    }

    @Override
    public Set<String> getUserMacroNames() {
        this.myLock.readLock().lock();
        try {
            THashSet tHashSet = new THashSet(this.myMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public static Set<String> getToolMacroNames() {
        return ourToolsMacros;
    }

    @Override
    public Set<String> getSystemMacroNames() {
        return SYSTEM_MACROS;
    }

    @Override
    public Collection<String> getIgnoredMacroNames() {
        return this.myIgnoredMacros;
    }

    @Override
    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/application/options/PathMacrosImpl", "setIgnoredMacroNames"));
        }
        this.myIgnoredMacros.clear();
        this.myIgnoredMacros.addAll(names);
    }

    @Override
    public void addIgnoredMacro(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/application/options/PathMacrosImpl", "addIgnoredMacro"));
        }
        if (!this.myIgnoredMacros.contains(name)) {
            this.myIgnoredMacros.add(name);
        }
    }

    public int getModificationStamp() {
        this.myLock.readLock().lock();
        try {
            int n = this.myModificationStamp;
            return n;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public boolean isIgnoredMacroName(@NotNull String macro) {
        if (macro == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", MACRO_ELEMENT, "com/intellij/application/options/PathMacrosImpl", "isIgnoredMacroName"));
        }
        return this.myIgnoredMacros.contains(macro);
    }

    @Override
    public Set<String> getAllMacroNames() {
        Set<String> userMacroNames = this.getUserMacroNames();
        Set<String> systemMacroNames = this.getSystemMacroNames();
        HashSet<String> allNames = new HashSet<String>(userMacroNames.size() + systemMacroNames.size());
        allNames.addAll(systemMacroNames);
        allNames.addAll(userMacroNames);
        return allNames;
    }

    @Override
    public String getValue(String name) {
        try {
            this.myLock.readLock().lock();
            String string = this.myMacros.get(name);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public void removeAllMacros() {
        try {
            this.myLock.writeLock().lock();
            this.myMacros.clear();
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public Collection<String> getLegacyMacroNames() {
        try {
            this.myLock.readLock().lock();
            THashSet tHashSet = new THashSet(this.myLegacyMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @Override
    public void setMacro(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/application/options/PathMacrosImpl", "setMacro"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VALUE_ATTR, "com/intellij/application/options/PathMacrosImpl", "setMacro"));
        }
        if (value.trim().isEmpty()) {
            return;
        }
        try {
            this.myLock.writeLock().lock();
            this.myMacros.put(name, value);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public void addLegacyMacro(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/application/options/PathMacrosImpl", "addLegacyMacro"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VALUE_ATTR, "com/intellij/application/options/PathMacrosImpl", "addLegacyMacro"));
        }
        try {
            this.myLock.writeLock().lock();
            this.myLegacyMacros.put(name, value);
            this.myMacros.remove(name);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public void removeMacro(String name) {
        try {
            this.myLock.writeLock().lock();
            String value = this.myMacros.remove(name);
            LOG.assertTrue(value != null);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state");
            this.myLock.writeLock().lock();
            for (Map.Entry<String, String> entry : this.myMacros.entrySet()) {
                String value = entry.getValue();
                if (StringUtil.isEmptyOrSpaces(value)) continue;
                Element macro = new Element(MACRO_ELEMENT);
                macro.setAttribute(NAME_ATTR, entry.getKey());
                macro.setAttribute(VALUE_ATTR, value);
                element.addContent(macro);
            }
            for (String macro : this.myIgnoredMacros) {
                Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
                macroElement.setAttribute(NAME_ATTR, macro);
                element.addContent(macroElement);
            }
            Iterator<Object> iterator = element;
            return iterator;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(Element element) {
        try {
            this.myLock.writeLock().lock();
            List children = element.getChildren(MACRO_ELEMENT);
            for (Object aChildren : children) {
                Element macro = (Element)aChildren;
                String name = macro.getAttributeValue(NAME_ATTR);
                String value = macro.getAttributeValue(VALUE_ATTR);
                if (name == null || value == null || SYSTEM_MACROS.contains(name)) continue;
                if (value.length() > 1 && value.charAt(value.length() - 1) == '/') {
                    value = value.substring(0, value.length() - 1);
                }
                this.myMacros.put(name, value);
            }
            List ignoredChildren = element.getChildren(IGNORED_MACRO_ELEMENT);
            for (Object child : ignoredChildren) {
                Element macroElement = (Element)child;
                String ignoredName = macroElement.getAttributeValue(NAME_ATTR);
                if (ignoredName == null || ignoredName.isEmpty() || this.myIgnoredMacros.contains(ignoredName)) continue;
                this.myIgnoredMacros.add(ignoredName);
            }
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void addMacroReplacements(ReplacePathToMacroMap result) {
        for (String name : this.getUserMacroNames()) {
            String value = this.getValue(name);
            if (value == null || value.trim().isEmpty()) continue;
            result.addMacroReplacement(value, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacroExpands(ExpandMacroToPathMap result) {
        for (String string : this.getUserMacroNames()) {
            String value = this.getValue(string);
            if (value == null || value.trim().isEmpty()) continue;
            result.addMacroExpand(string, value);
        }
        this.myLock.readLock().lock();
        try {
            for (Map.Entry entry : this.myLegacyMacros.entrySet()) {
                result.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    static {
        SYSTEM_MACROS.add(APPLICATION_HOME_MACRO_NAME);
        SYSTEM_MACROS.add("APPLICATION_PLUGINS_DIR");
        SYSTEM_MACROS.add(PROJECT_DIR_MACRO_NAME);
        SYSTEM_MACROS.add(MODULE_DIR_MACRO_NAME);
        SYSTEM_MACROS.add(USER_HOME_MACRO_NAME);
        ourToolsMacros = ContainerUtil.immutableSet("ClasspathEntry", "Classpath", "ColumnNumber", "FileClass", "FileDir", "FileParentDir", "FileDirName", "FileDirPathFromParent", "FileDirRelativeToProjectRoot", "/FileDirRelativeToProjectRoot", "FileDirRelativeToSourcepath", "/FileDirRelativeToSourcepath", "FileExt", "FileFQPackage", "FileName", "FileNameWithoutExtension", "FileNameWithoutAllExtensions", "FilePackage", "FilePath", "UnixSeparators", "FilePathRelativeToProjectRoot", "/FilePathRelativeToProjectRoot", "FilePathRelativeToSourcepath", "/FilePathRelativeToSourcepath", "FilePrompt", "FileRelativeDir", "/FileRelativeDir", "FileRelativePath", "/FileRelativePath", "FileEncoding", "JavaDocPath", "JDKPath", "LineNumber", "ModuleFileDir", "ModuleFilePath", "ModuleName", "ModuleSourcePath", "ModuleSdkPath", "OutputPath", "PhpExecutable", "ProjectFileDir", "ProjectFilePath", "ProjectName", "Projectpath", "Prompt", "SourcepathEntry", "Sourcepath", "SHOW_CHANGES", "ClipboardContent", "SelectedText", "SelectionStartLine", "SelectionEndLine", "SelectionStartColumn", "SelectionEndColumn", "PyInterpreterDirectory");
    }
}

