/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSwitchStatementVisitor();
    }

    private static class NestedSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSwitchStatementVisitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection$NestedSwitchStatementVisitor", "visitSwitchStatement"));
            }
            super.visitSwitchStatement(statement);
            PsiSwitchStatement containingSwitchStatement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchStatement.class);
            if (containingSwitchStatement == null) {
                return;
            }
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            PsiMethod containingContainingMethod = PsiTreeUtil.getParentOfType((PsiElement)containingSwitchStatement, PsiMethod.class);
            if (containingMethod == null || containingContainingMethod == null || !containingMethod.equals(containingContainingMethod)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }
    }
}

